/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.internal.auth;

import cz.o2.proxima.s3.shaded.com.amazonaws.AmazonWebServiceClient;
import cz.o2.proxima.s3.shaded.com.amazonaws.auth.RegionAwareSigner;
import cz.o2.proxima.s3.shaded.com.amazonaws.auth.Signer;
import cz.o2.proxima.s3.shaded.com.amazonaws.internal.auth.SignerProvider;
import cz.o2.proxima.s3.shaded.com.amazonaws.internal.auth.SignerProviderContext;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.internal.ServiceUtils;
import cz.o2.proxima.s3.shaded.com.amazonaws.util.AwsHostNameUtils;
import cz.o2.proxima.s3.shaded.org.apache.commons.logging.Log;
import cz.o2.proxima.s3.shaded.org.apache.commons.logging.LogFactory;
import java.net.URI;

public class S3SignerProvider
extends SignerProvider {
    private static Log log = LogFactory.getLog(S3SignerProvider.class);
    private final AmazonWebServiceClient awsClient;
    private Signer signer;

    public S3SignerProvider(AmazonWebServiceClient awsClient, Signer defaultSigner) {
        this.awsClient = awsClient;
        this.signer = defaultSigner;
    }

    @Override
    public Signer getSigner(SignerProviderContext signerProviderContext) {
        URI uri = signerProviderContext.getUri();
        if (uri == null || ServiceUtils.isS3AccelerateEndpoint(uri.getHost()) || this.isSignerRegionOverrideSet()) {
            return this.signer;
        }
        if (this.signer instanceof RegionAwareSigner && !this.isAccessPointUri(uri)) {
            RegionAwareSigner regionSigner = (RegionAwareSigner)this.signer;
            try {
                regionSigner.setRegionName(AwsHostNameUtils.parseRegionName(uri.getHost(), "s3"));
            }
            catch (RuntimeException e) {
                log.warn("Failed to parse the endpoint " + uri + ", and skip re-assigning the signer region", e);
            }
        }
        return this.signer;
    }

    private boolean isAccessPointUri(URI uri) {
        return uri.toASCIIString().contains(".s3-accesspoint.");
    }

    private boolean isSignerRegionOverrideSet() {
        return this.awsClient != null && this.awsClient.getSignerRegionOverride() != null;
    }

    public void setSigner(Signer signer) {
        this.signer = signer;
    }
}

