/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model;

import cz.o2.proxima.s3.shaded.com.amazonaws.internal.MetricAware;
import cz.o2.proxima.s3.shaded.com.amazonaws.internal.SdkFilterInputStream;
import cz.o2.proxima.s3.shaded.com.amazonaws.metrics.AwsSdkMetrics;
import cz.o2.proxima.s3.shaded.com.amazonaws.metrics.MetricFilterInputStream;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.metrics.S3ServiceMetric;
import cz.o2.proxima.s3.shaded.com.amazonaws.util.IOUtils;
import cz.o2.proxima.s3.shaded.org.apache.http.client.methods.HttpRequestBase;
import java.io.IOException;
import java.io.InputStream;

public class S3ObjectInputStream
extends SdkFilterInputStream {
    private final HttpRequestBase httpRequest;

    public S3ObjectInputStream(InputStream in, HttpRequestBase httpRequest) {
        this(in, httpRequest, S3ObjectInputStream.wrapWithByteCounting(in));
    }

    public S3ObjectInputStream(InputStream in, HttpRequestBase httpRequest, boolean collectMetrics) {
        super(collectMetrics ? new MetricFilterInputStream(S3ServiceMetric.S3DownloadThroughput, in) : in);
        this.httpRequest = httpRequest;
    }

    private static boolean wrapWithByteCounting(InputStream in) {
        if (!AwsSdkMetrics.isMetricsEnabled()) {
            return false;
        }
        if (in instanceof MetricAware) {
            MetricAware aware = (MetricAware)((Object)in);
            return !aware.isMetricActivated();
        }
        return true;
    }

    @Override
    public void abort() {
        super.abort();
        if (this.httpRequest != null) {
            this.httpRequest.abort();
        }
        if (!(this.in instanceof SdkFilterInputStream)) {
            IOUtils.closeQuietly(this.in, null);
        }
    }

    public HttpRequestBase getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public int available() throws IOException {
        int estimate = super.available();
        return estimate == 0 ? 1 : estimate;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }
}

