/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.waiters;

import cz.o2.proxima.s3.shaded.com.amazonaws.annotation.SdkInternalApi;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.AmazonS3;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model.GetObjectMetadataRequest;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model.HeadBucketRequest;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model.HeadBucketResult;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.model.ObjectMetadata;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.waiters.HeadBucketFunction;
import cz.o2.proxima.s3.shaded.com.amazonaws.services.s3.waiters.HeadObjectFunction;
import cz.o2.proxima.s3.shaded.com.amazonaws.waiters.FixedDelayStrategy;
import cz.o2.proxima.s3.shaded.com.amazonaws.waiters.HttpFailureStatusAcceptor;
import cz.o2.proxima.s3.shaded.com.amazonaws.waiters.HttpSuccessStatusAcceptor;
import cz.o2.proxima.s3.shaded.com.amazonaws.waiters.MaxAttemptsRetryStrategy;
import cz.o2.proxima.s3.shaded.com.amazonaws.waiters.PollingStrategy;
import cz.o2.proxima.s3.shaded.com.amazonaws.waiters.Waiter;
import cz.o2.proxima.s3.shaded.com.amazonaws.waiters.WaiterBuilder;
import cz.o2.proxima.s3.shaded.com.amazonaws.waiters.WaiterState;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class AmazonS3Waiters {
    private final AmazonS3 client;
    private final ExecutorService executorService = Executors.newFixedThreadPool(50);

    @SdkInternalApi
    public AmazonS3Waiters(AmazonS3 client) {
        this.client = client;
    }

    public Waiter<HeadBucketRequest> bucketNotExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<HeadBucketRequest> bucketExists() {
        return new WaiterBuilder<HeadBucketRequest, HeadBucketResult>().withSdkFunction(new HeadBucketFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(301, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(403, WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetObjectMetadataRequest> objectExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpSuccessStatusAcceptor(WaiterState.SUCCESS), new HttpFailureStatusAcceptor(404, WaiterState.RETRY)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }

    public Waiter<GetObjectMetadataRequest> objectNotExists() {
        return new WaiterBuilder<GetObjectMetadataRequest, ObjectMetadata>().withSdkFunction(new HeadObjectFunction(this.client)).withAcceptors(new HttpFailureStatusAcceptor(404, WaiterState.SUCCESS)).withDefaultPollingStrategy(new PollingStrategy(new MaxAttemptsRetryStrategy(20), new FixedDelayStrategy(5))).withExecutorService(this.executorService).build();
    }
}

