/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.com.amazonaws.transform;

import cz.o2.proxima.s3.shaded.com.amazonaws.AmazonServiceException;
import cz.o2.proxima.s3.shaded.com.amazonaws.annotation.SdkInternalApi;
import cz.o2.proxima.s3.shaded.com.amazonaws.annotation.ThreadSafe;
import cz.o2.proxima.s3.shaded.com.amazonaws.transform.AbstractErrorUnmarshaller;
import cz.o2.proxima.s3.shaded.com.fasterxml.jackson.databind.DeserializationFeature;
import cz.o2.proxima.s3.shaded.com.fasterxml.jackson.databind.JsonNode;
import cz.o2.proxima.s3.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import cz.o2.proxima.s3.shaded.com.fasterxml.jackson.databind.PropertyNamingStrategy;

@SdkInternalApi
@ThreadSafe
public class JsonErrorUnmarshaller
extends AbstractErrorUnmarshaller<JsonNode> {
    public static final JsonErrorUnmarshaller DEFAULT_UNMARSHALLER = new JsonErrorUnmarshaller(AmazonServiceException.class, null);
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).setPropertyNamingStrategy(new PropertyNamingStrategy.PascalCaseStrategy());
    private final String handledErrorCode;

    public JsonErrorUnmarshaller(Class<? extends AmazonServiceException> exceptionClass, String handledErrorCode) {
        super(exceptionClass);
        this.handledErrorCode = handledErrorCode;
    }

    @Override
    public AmazonServiceException unmarshall(JsonNode jsonContent) throws Exception {
        return (AmazonServiceException)MAPPER.treeToValue(jsonContent, this.exceptionClass);
    }

    public boolean matchErrorCode(String actualErrorCode) {
        if (this.handledErrorCode == null) {
            return true;
        }
        return this.handledErrorCode.equals(actualErrorCode);
    }
}

