/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.org.apache.http.client.protocol;

import cz.o2.proxima.s3.shaded.org.apache.http.Header;
import cz.o2.proxima.s3.shaded.org.apache.http.HeaderElement;
import cz.o2.proxima.s3.shaded.org.apache.http.HttpEntity;
import cz.o2.proxima.s3.shaded.org.apache.http.HttpException;
import cz.o2.proxima.s3.shaded.org.apache.http.HttpResponse;
import cz.o2.proxima.s3.shaded.org.apache.http.HttpResponseInterceptor;
import cz.o2.proxima.s3.shaded.org.apache.http.annotation.Contract;
import cz.o2.proxima.s3.shaded.org.apache.http.annotation.ThreadingBehavior;
import cz.o2.proxima.s3.shaded.org.apache.http.client.config.RequestConfig;
import cz.o2.proxima.s3.shaded.org.apache.http.client.entity.DecompressingEntity;
import cz.o2.proxima.s3.shaded.org.apache.http.client.entity.DeflateInputStreamFactory;
import cz.o2.proxima.s3.shaded.org.apache.http.client.entity.GZIPInputStreamFactory;
import cz.o2.proxima.s3.shaded.org.apache.http.client.entity.InputStreamFactory;
import cz.o2.proxima.s3.shaded.org.apache.http.client.protocol.HttpClientContext;
import cz.o2.proxima.s3.shaded.org.apache.http.config.Lookup;
import cz.o2.proxima.s3.shaded.org.apache.http.config.RegistryBuilder;
import cz.o2.proxima.s3.shaded.org.apache.http.protocol.HttpContext;
import java.io.IOException;
import java.util.Locale;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class ResponseContentEncoding
implements HttpResponseInterceptor {
    public static final String UNCOMPRESSED = "http.client.response.uncompressed";
    private final Lookup<InputStreamFactory> decoderRegistry;
    private final boolean ignoreUnknown;

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry, boolean ignoreUnknown) {
        this.decoderRegistry = decoderRegistry != null ? decoderRegistry : RegistryBuilder.create().register("gzip", GZIPInputStreamFactory.getInstance()).register("x-gzip", GZIPInputStreamFactory.getInstance()).register("deflate", (GZIPInputStreamFactory)((Object)DeflateInputStreamFactory.getInstance())).build();
        this.ignoreUnknown = ignoreUnknown;
    }

    public ResponseContentEncoding(boolean ignoreUnknown) {
        this(null, ignoreUnknown);
    }

    public ResponseContentEncoding(Lookup<InputStreamFactory> decoderRegistry) {
        this(decoderRegistry, true);
    }

    public ResponseContentEncoding() {
        this(null);
    }

    @Override
    public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
        Header ceheader;
        HttpEntity entity = response.getEntity();
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RequestConfig requestConfig = clientContext.getRequestConfig();
        if (requestConfig.isContentCompressionEnabled() && entity != null && entity.getContentLength() != 0L && (ceheader = entity.getContentEncoding()) != null) {
            HeaderElement[] codecs;
            for (HeaderElement codec : codecs = ceheader.getElements()) {
                String codecname = codec.getName().toLowerCase(Locale.ROOT);
                InputStreamFactory decoderFactory = this.decoderRegistry.lookup(codecname);
                if (decoderFactory != null) {
                    response.setEntity(new DecompressingEntity(response.getEntity(), decoderFactory));
                    response.removeHeaders("Content-Length");
                    response.removeHeaders("Content-Encoding");
                    response.removeHeaders("Content-MD5");
                    continue;
                }
                if ("identity".equals(codecname) || this.ignoreUnknown) continue;
                throw new HttpException("Unsupported Content-Encoding: " + codec.getName());
            }
        }
    }
}

