/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.org.apache.http.impl.client;

import cz.o2.proxima.s3.shaded.org.apache.http.HeaderElement;
import cz.o2.proxima.s3.shaded.org.apache.http.HttpResponse;
import cz.o2.proxima.s3.shaded.org.apache.http.annotation.Contract;
import cz.o2.proxima.s3.shaded.org.apache.http.annotation.ThreadingBehavior;
import cz.o2.proxima.s3.shaded.org.apache.http.conn.ConnectionKeepAliveStrategy;
import cz.o2.proxima.s3.shaded.org.apache.http.message.BasicHeaderElementIterator;
import cz.o2.proxima.s3.shaded.org.apache.http.protocol.HttpContext;
import cz.o2.proxima.s3.shaded.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class DefaultConnectionKeepAliveStrategy
implements ConnectionKeepAliveStrategy {
    public static final DefaultConnectionKeepAliveStrategy INSTANCE = new DefaultConnectionKeepAliveStrategy();

    @Override
    public long getKeepAliveDuration(HttpResponse response, HttpContext context) {
        Args.notNull(response, "HTTP response");
        BasicHeaderElementIterator it = new BasicHeaderElementIterator(response.headerIterator("Keep-Alive"));
        while (it.hasNext()) {
            HeaderElement he = it.nextElement();
            String param = he.getName();
            String value = he.getValue();
            if (value == null || !param.equalsIgnoreCase("timeout")) continue;
            try {
                return Long.parseLong(value) * 1000L;
            }
            catch (NumberFormatException ignore) {
            }
        }
        return -1L;
    }
}

