/*
 * Decompiled with CFR 0.152.
 */
package cz.o2.proxima.s3.shaded.org.apache.http.impl.client;

import cz.o2.proxima.s3.shaded.org.apache.http.HttpException;
import cz.o2.proxima.s3.shaded.org.apache.http.HttpHost;
import cz.o2.proxima.s3.shaded.org.apache.http.HttpRequest;
import cz.o2.proxima.s3.shaded.org.apache.http.annotation.Contract;
import cz.o2.proxima.s3.shaded.org.apache.http.annotation.ThreadingBehavior;
import cz.o2.proxima.s3.shaded.org.apache.http.client.ClientProtocolException;
import cz.o2.proxima.s3.shaded.org.apache.http.client.config.RequestConfig;
import cz.o2.proxima.s3.shaded.org.apache.http.client.methods.CloseableHttpResponse;
import cz.o2.proxima.s3.shaded.org.apache.http.client.methods.Configurable;
import cz.o2.proxima.s3.shaded.org.apache.http.client.methods.HttpExecutionAware;
import cz.o2.proxima.s3.shaded.org.apache.http.client.methods.HttpRequestWrapper;
import cz.o2.proxima.s3.shaded.org.apache.http.client.protocol.HttpClientContext;
import cz.o2.proxima.s3.shaded.org.apache.http.conn.ClientConnectionManager;
import cz.o2.proxima.s3.shaded.org.apache.http.conn.ClientConnectionRequest;
import cz.o2.proxima.s3.shaded.org.apache.http.conn.HttpClientConnectionManager;
import cz.o2.proxima.s3.shaded.org.apache.http.conn.ManagedClientConnection;
import cz.o2.proxima.s3.shaded.org.apache.http.conn.routing.HttpRoute;
import cz.o2.proxima.s3.shaded.org.apache.http.conn.scheme.SchemeRegistry;
import cz.o2.proxima.s3.shaded.org.apache.http.impl.DefaultConnectionReuseStrategy;
import cz.o2.proxima.s3.shaded.org.apache.http.impl.client.CloseableHttpClient;
import cz.o2.proxima.s3.shaded.org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import cz.o2.proxima.s3.shaded.org.apache.http.impl.execchain.MinimalClientExec;
import cz.o2.proxima.s3.shaded.org.apache.http.params.BasicHttpParams;
import cz.o2.proxima.s3.shaded.org.apache.http.params.HttpParams;
import cz.o2.proxima.s3.shaded.org.apache.http.protocol.BasicHttpContext;
import cz.o2.proxima.s3.shaded.org.apache.http.protocol.HttpContext;
import cz.o2.proxima.s3.shaded.org.apache.http.protocol.HttpRequestExecutor;
import cz.o2.proxima.s3.shaded.org.apache.http.util.Args;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

@Contract(threading=ThreadingBehavior.SAFE_CONDITIONAL)
class MinimalHttpClient
extends CloseableHttpClient {
    private final HttpClientConnectionManager connManager;
    private final MinimalClientExec requestExecutor;
    private final HttpParams params;

    public MinimalHttpClient(HttpClientConnectionManager connManager) {
        this.connManager = Args.notNull(connManager, "HTTP connection manager");
        this.requestExecutor = new MinimalClientExec(new HttpRequestExecutor(), connManager, DefaultConnectionReuseStrategy.INSTANCE, DefaultConnectionKeepAliveStrategy.INSTANCE);
        this.params = new BasicHttpParams();
    }

    @Override
    protected CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(target, "Target host");
        Args.notNull(request, "HTTP request");
        HttpExecutionAware execAware = null;
        if (request instanceof HttpExecutionAware) {
            execAware = (HttpExecutionAware)((Object)request);
        }
        try {
            HttpRequestWrapper wrapper = HttpRequestWrapper.wrap(request);
            HttpClientContext localcontext = HttpClientContext.adapt(context != null ? context : new BasicHttpContext());
            HttpRoute route = new HttpRoute(target);
            RequestConfig config = null;
            if (request instanceof Configurable) {
                config = ((Configurable)((Object)request)).getConfig();
            }
            if (config != null) {
                localcontext.setRequestConfig(config);
            }
            return this.requestExecutor.execute(route, wrapper, localcontext, execAware);
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    @Override
    public HttpParams getParams() {
        return this.params;
    }

    @Override
    public void close() {
        this.connManager.shutdown();
    }

    @Override
    public ClientConnectionManager getConnectionManager() {
        return new ClientConnectionManager(){

            @Override
            public void shutdown() {
                MinimalHttpClient.this.connManager.shutdown();
            }

            @Override
            public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
                throw new UnsupportedOperationException();
            }

            @Override
            public SchemeRegistry getSchemeRegistry() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void closeIdleConnections(long idletime, TimeUnit timeUnit) {
                MinimalHttpClient.this.connManager.closeIdleConnections(idletime, timeUnit);
            }

            @Override
            public void closeExpiredConnections() {
                MinimalHttpClient.this.connManager.closeExpiredConnections();
            }
        };
    }
}

