package cz.o2.proxima.direct.server.rpc.proto.service;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * <pre>
 **
 * Ingest service serves as data entry point. All data
 * is sent to the system via this endpoint.
 * </pre>
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.56.1)",
    comments = "Source: rpc.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class IngestServiceGrpc {

  private IngestServiceGrpc() {}

  public static final String SERVICE_NAME = "IngestService";

  // Static method descriptors that strictly reflect the proto.
  private static volatile io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.IngestBulk,
      cz.o2.proxima.direct.server.rpc.proto.service.Rpc.StatusBulk> getIngestBulkMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ingestBulk",
      requestType = cz.o2.proxima.direct.server.rpc.proto.service.Rpc.IngestBulk.class,
      responseType = cz.o2.proxima.direct.server.rpc.proto.service.Rpc.StatusBulk.class,
      methodType = io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.IngestBulk,
      cz.o2.proxima.direct.server.rpc.proto.service.Rpc.StatusBulk> getIngestBulkMethod() {
    io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.IngestBulk, cz.o2.proxima.direct.server.rpc.proto.service.Rpc.StatusBulk> getIngestBulkMethod;
    if ((getIngestBulkMethod = IngestServiceGrpc.getIngestBulkMethod) == null) {
      synchronized (IngestServiceGrpc.class) {
        if ((getIngestBulkMethod = IngestServiceGrpc.getIngestBulkMethod) == null) {
          IngestServiceGrpc.getIngestBulkMethod = getIngestBulkMethod =
              io.grpc.MethodDescriptor.<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.IngestBulk, cz.o2.proxima.direct.server.rpc.proto.service.Rpc.StatusBulk>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ingestBulk"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  cz.o2.proxima.direct.server.rpc.proto.service.Rpc.IngestBulk.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  cz.o2.proxima.direct.server.rpc.proto.service.Rpc.StatusBulk.getDefaultInstance()))
              .setSchemaDescriptor(new IngestServiceMethodDescriptorSupplier("ingestBulk"))
              .build();
        }
      }
    }
    return getIngestBulkMethod;
  }

  private static volatile io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest,
      cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> getIngestSingleMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ingestSingle",
      requestType = cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest.class,
      responseType = cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
  public static io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest,
      cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> getIngestSingleMethod() {
    io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest, cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> getIngestSingleMethod;
    if ((getIngestSingleMethod = IngestServiceGrpc.getIngestSingleMethod) == null) {
      synchronized (IngestServiceGrpc.class) {
        if ((getIngestSingleMethod = IngestServiceGrpc.getIngestSingleMethod) == null) {
          IngestServiceGrpc.getIngestSingleMethod = getIngestSingleMethod =
              io.grpc.MethodDescriptor.<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest, cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ingestSingle"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new IngestServiceMethodDescriptorSupplier("ingestSingle"))
              .build();
        }
      }
    }
    return getIngestSingleMethod;
  }

  private static volatile io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest,
      cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> getIngestMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "ingest",
      requestType = cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest.class,
      responseType = cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest,
      cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> getIngestMethod() {
    io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest, cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> getIngestMethod;
    if ((getIngestMethod = IngestServiceGrpc.getIngestMethod) == null) {
      synchronized (IngestServiceGrpc.class) {
        if ((getIngestMethod = IngestServiceGrpc.getIngestMethod) == null) {
          IngestServiceGrpc.getIngestMethod = getIngestMethod =
              io.grpc.MethodDescriptor.<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest, cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "ingest"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status.getDefaultInstance()))
              .setSchemaDescriptor(new IngestServiceMethodDescriptorSupplier("ingest"))
              .build();
        }
      }
    }
    return getIngestMethod;
  }

  private static volatile io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest,
      cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse> getCommitMethod;

  @io.grpc.stub.annotations.RpcMethod(
      fullMethodName = SERVICE_NAME + '/' + "commit",
      requestType = cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest.class,
      responseType = cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse.class,
      methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
  public static io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest,
      cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse> getCommitMethod() {
    io.grpc.MethodDescriptor<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest, cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse> getCommitMethod;
    if ((getCommitMethod = IngestServiceGrpc.getCommitMethod) == null) {
      synchronized (IngestServiceGrpc.class) {
        if ((getCommitMethod = IngestServiceGrpc.getCommitMethod) == null) {
          IngestServiceGrpc.getCommitMethod = getCommitMethod =
              io.grpc.MethodDescriptor.<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest, cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse>newBuilder()
              .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
              .setFullMethodName(generateFullMethodName(SERVICE_NAME, "commit"))
              .setSampledToLocalTracing(true)
              .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest.getDefaultInstance()))
              .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                  cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse.getDefaultInstance()))
              .setSchemaDescriptor(new IngestServiceMethodDescriptorSupplier("commit"))
              .build();
        }
      }
    }
    return getCommitMethod;
  }

  /**
   * Creates a new async stub that supports all call types for the service
   */
  public static IngestServiceStub newStub(io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<IngestServiceStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<IngestServiceStub>() {
        @java.lang.Override
        public IngestServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new IngestServiceStub(channel, callOptions);
        }
      };
    return IngestServiceStub.newStub(factory, channel);
  }

  /**
   * Creates a new blocking-style stub that supports unary and streaming output calls on the service
   */
  public static IngestServiceBlockingStub newBlockingStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<IngestServiceBlockingStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<IngestServiceBlockingStub>() {
        @java.lang.Override
        public IngestServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new IngestServiceBlockingStub(channel, callOptions);
        }
      };
    return IngestServiceBlockingStub.newStub(factory, channel);
  }

  /**
   * Creates a new ListenableFuture-style stub that supports unary calls on the service
   */
  public static IngestServiceFutureStub newFutureStub(
      io.grpc.Channel channel) {
    io.grpc.stub.AbstractStub.StubFactory<IngestServiceFutureStub> factory =
      new io.grpc.stub.AbstractStub.StubFactory<IngestServiceFutureStub>() {
        @java.lang.Override
        public IngestServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
          return new IngestServiceFutureStub(channel, callOptions);
        }
      };
    return IngestServiceFutureStub.newStub(factory, channel);
  }

  /**
   * <pre>
   **
   * Ingest service serves as data entry point. All data
   * is sent to the system via this endpoint.
   * </pre>
   */
  public interface AsyncService {

    /**
     * <pre>
     **
     * The main ingest method. Use this for high performance ingest requests.
     * Note that the returned StatusBulk will not be necesarilly corresponding
     * the the input bulk. So each IngestBulk can result in any number of
     * StatusBulk messages. It is up to the application to handle the
     * StatusBulk as a stream of individual Statuses.
     * </pre>
     */
    default io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.IngestBulk> ingestBulk(
        io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.StatusBulk> responseObserver) {
      return io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall(getIngestBulkMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Stream ingestion with single ingest requests. Use this method when
     * sending small isolated and infrequent ingest requests.
     * </pre>
     */
    default io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest> ingestSingle(
        io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> responseObserver) {
      return io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall(getIngestSingleMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * Synchronous ingest request.
     * </pre>
     */
    default void ingest(cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest request,
        io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getIngestMethod(), responseObserver);
    }

    /**
     * <pre>
     **
     * A synchronous request to commit a transaction.
     * </pre>
     */
    default void commit(cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest request,
        io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse> responseObserver) {
      io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getCommitMethod(), responseObserver);
    }
  }

  /**
   * Base class for the server implementation of the service IngestService.
   * <pre>
   **
   * Ingest service serves as data entry point. All data
   * is sent to the system via this endpoint.
   * </pre>
   */
  public static abstract class IngestServiceImplBase
      implements io.grpc.BindableService, AsyncService {

    @java.lang.Override public final io.grpc.ServerServiceDefinition bindService() {
      return IngestServiceGrpc.bindService(this);
    }
  }

  /**
   * A stub to allow clients to do asynchronous rpc calls to service IngestService.
   * <pre>
   **
   * Ingest service serves as data entry point. All data
   * is sent to the system via this endpoint.
   * </pre>
   */
  public static final class IngestServiceStub
      extends io.grpc.stub.AbstractAsyncStub<IngestServiceStub> {
    private IngestServiceStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected IngestServiceStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new IngestServiceStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * The main ingest method. Use this for high performance ingest requests.
     * Note that the returned StatusBulk will not be necesarilly corresponding
     * the the input bulk. So each IngestBulk can result in any number of
     * StatusBulk messages. It is up to the application to handle the
     * StatusBulk as a stream of individual Statuses.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.IngestBulk> ingestBulk(
        io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.StatusBulk> responseObserver) {
      return io.grpc.stub.ClientCalls.asyncBidiStreamingCall(
          getChannel().newCall(getIngestBulkMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     **
     * Stream ingestion with single ingest requests. Use this method when
     * sending small isolated and infrequent ingest requests.
     * </pre>
     */
    public io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest> ingestSingle(
        io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> responseObserver) {
      return io.grpc.stub.ClientCalls.asyncBidiStreamingCall(
          getChannel().newCall(getIngestSingleMethod(), getCallOptions()), responseObserver);
    }

    /**
     * <pre>
     **
     * Synchronous ingest request.
     * </pre>
     */
    public void ingest(cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest request,
        io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getIngestMethod(), getCallOptions()), request, responseObserver);
    }

    /**
     * <pre>
     **
     * A synchronous request to commit a transaction.
     * </pre>
     */
    public void commit(cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest request,
        io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse> responseObserver) {
      io.grpc.stub.ClientCalls.asyncUnaryCall(
          getChannel().newCall(getCommitMethod(), getCallOptions()), request, responseObserver);
    }
  }

  /**
   * A stub to allow clients to do synchronous rpc calls to service IngestService.
   * <pre>
   **
   * Ingest service serves as data entry point. All data
   * is sent to the system via this endpoint.
   * </pre>
   */
  public static final class IngestServiceBlockingStub
      extends io.grpc.stub.AbstractBlockingStub<IngestServiceBlockingStub> {
    private IngestServiceBlockingStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected IngestServiceBlockingStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new IngestServiceBlockingStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Synchronous ingest request.
     * </pre>
     */
    public cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status ingest(cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getIngestMethod(), getCallOptions(), request);
    }

    /**
     * <pre>
     **
     * A synchronous request to commit a transaction.
     * </pre>
     */
    public cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse commit(cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest request) {
      return io.grpc.stub.ClientCalls.blockingUnaryCall(
          getChannel(), getCommitMethod(), getCallOptions(), request);
    }
  }

  /**
   * A stub to allow clients to do ListenableFuture-style rpc calls to service IngestService.
   * <pre>
   **
   * Ingest service serves as data entry point. All data
   * is sent to the system via this endpoint.
   * </pre>
   */
  public static final class IngestServiceFutureStub
      extends io.grpc.stub.AbstractFutureStub<IngestServiceFutureStub> {
    private IngestServiceFutureStub(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      super(channel, callOptions);
    }

    @java.lang.Override
    protected IngestServiceFutureStub build(
        io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
      return new IngestServiceFutureStub(channel, callOptions);
    }

    /**
     * <pre>
     **
     * Synchronous ingest request.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status> ingest(
        cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getIngestMethod(), getCallOptions()), request);
    }

    /**
     * <pre>
     **
     * A synchronous request to commit a transaction.
     * </pre>
     */
    public com.google.common.util.concurrent.ListenableFuture<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse> commit(
        cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest request) {
      return io.grpc.stub.ClientCalls.futureUnaryCall(
          getChannel().newCall(getCommitMethod(), getCallOptions()), request);
    }
  }

  private static final int METHODID_INGEST = 0;
  private static final int METHODID_COMMIT = 1;
  private static final int METHODID_INGEST_BULK = 2;
  private static final int METHODID_INGEST_SINGLE = 3;

  private static final class MethodHandlers<Req, Resp> implements
      io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
      io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {
    private final AsyncService serviceImpl;
    private final int methodId;

    MethodHandlers(AsyncService serviceImpl, int methodId) {
      this.serviceImpl = serviceImpl;
      this.methodId = methodId;
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_INGEST:
          serviceImpl.ingest((cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest) request,
              (io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status>) responseObserver);
          break;
        case METHODID_COMMIT:
          serviceImpl.commit((cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest) request,
              (io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse>) responseObserver);
          break;
        default:
          throw new AssertionError();
      }
    }

    @java.lang.Override
    @java.lang.SuppressWarnings("unchecked")
    public io.grpc.stub.StreamObserver<Req> invoke(
        io.grpc.stub.StreamObserver<Resp> responseObserver) {
      switch (methodId) {
        case METHODID_INGEST_BULK:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.ingestBulk(
              (io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.StatusBulk>) responseObserver);
        case METHODID_INGEST_SINGLE:
          return (io.grpc.stub.StreamObserver<Req>) serviceImpl.ingestSingle(
              (io.grpc.stub.StreamObserver<cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status>) responseObserver);
        default:
          throw new AssertionError();
      }
    }
  }

  public static final io.grpc.ServerServiceDefinition bindService(AsyncService service) {
    return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
        .addMethod(
          getIngestBulkMethod(),
          io.grpc.stub.ServerCalls.asyncBidiStreamingCall(
            new MethodHandlers<
              cz.o2.proxima.direct.server.rpc.proto.service.Rpc.IngestBulk,
              cz.o2.proxima.direct.server.rpc.proto.service.Rpc.StatusBulk>(
                service, METHODID_INGEST_BULK)))
        .addMethod(
          getIngestSingleMethod(),
          io.grpc.stub.ServerCalls.asyncBidiStreamingCall(
            new MethodHandlers<
              cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest,
              cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status>(
                service, METHODID_INGEST_SINGLE)))
        .addMethod(
          getIngestMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Ingest,
              cz.o2.proxima.direct.server.rpc.proto.service.Rpc.Status>(
                service, METHODID_INGEST)))
        .addMethod(
          getCommitMethod(),
          io.grpc.stub.ServerCalls.asyncUnaryCall(
            new MethodHandlers<
              cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitRequest,
              cz.o2.proxima.direct.server.rpc.proto.service.Rpc.TransactionCommitResponse>(
                service, METHODID_COMMIT)))
        .build();
  }

  private static abstract class IngestServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {
    IngestServiceBaseDescriptorSupplier() {}

    @java.lang.Override
    public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
      return cz.o2.proxima.direct.server.rpc.proto.service.Rpc.getDescriptor();
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
      return getFileDescriptor().findServiceByName("IngestService");
    }
  }

  private static final class IngestServiceFileDescriptorSupplier
      extends IngestServiceBaseDescriptorSupplier {
    IngestServiceFileDescriptorSupplier() {}
  }

  private static final class IngestServiceMethodDescriptorSupplier
      extends IngestServiceBaseDescriptorSupplier
      implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {
    private final String methodName;

    IngestServiceMethodDescriptorSupplier(String methodName) {
      this.methodName = methodName;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
      return getServiceDescriptor().findMethodByName(methodName);
    }
  }

  private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

  public static io.grpc.ServiceDescriptor getServiceDescriptor() {
    io.grpc.ServiceDescriptor result = serviceDescriptor;
    if (result == null) {
      synchronized (IngestServiceGrpc.class) {
        result = serviceDescriptor;
        if (result == null) {
          serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
              .setSchemaDescriptor(new IngestServiceFileDescriptorSupplier())
              .addMethod(getIngestBulkMethod())
              .addMethod(getIngestSingleMethod())
              .addMethod(getIngestMethod())
              .addMethod(getCommitMethod())
              .build();
        }
      }
    }
    return result;
  }
}
