/*
 * Decompiled with CFR 0.152.
 */
package cz.vutbr.fit.layout.cssbox.impl;

import cz.vutbr.fit.layout.cssbox.impl.BoxListRenderer;
import cz.vutbr.fit.layout.cssbox.impl.BoxNode;
import cz.vutbr.fit.layout.cssbox.impl.PageImpl;
import cz.vutbr.fit.layout.cssbox.impl.Units;
import cz.vutbr.fit.layout.impl.BaseBoxTreeBuilder;
import cz.vutbr.fit.layout.impl.DefaultBox;
import cz.vutbr.fit.layout.model.Box;
import cz.vutbr.fit.layout.model.Color;
import cz.vutbr.fit.layout.model.GenericTreeNode;
import cz.vutbr.fit.layout.model.Page;
import cz.vutbr.fit.layout.model.Rectangular;
import cz.vutbr.web.css.MediaSpec;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.eclipse.rdf4j.model.IRI;
import org.fit.cssbox.awt.GraphicsEngine;
import org.fit.cssbox.css.CSSNorm;
import org.fit.cssbox.css.DOMAnalyzer;
import org.fit.cssbox.io.DefaultDOMSource;
import org.fit.cssbox.io.DefaultDocumentSource;
import org.fit.cssbox.io.DocumentSource;
import org.fit.cssbox.layout.BrowserConfig;
import org.fit.cssbox.layout.Dimension;
import org.fit.cssbox.layout.Engine;
import org.fit.cssbox.layout.Rectangle;
import org.fit.cssbox.layout.Viewport;
import org.fit.cssbox.pdf.PdfEngine;
import org.fit.cssbox.render.BoxRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CSSBoxTreeBuilder
extends BaseBoxTreeBuilder {
    private static Logger log = LoggerFactory.getLogger(CSSBoxTreeBuilder.class);
    protected URL pageUrl;
    protected String pageTitle;
    protected PageImpl page;
    protected Viewport viewport;
    protected Dimension pageSize;
    protected boolean replaceImagesWithAlt;
    private boolean acquireImages;
    private boolean includeScreenshot;
    private float zoom;

    public CSSBoxTreeBuilder(Dimension pageSize, boolean useVisualBounds, boolean preserveAux, boolean replaceImagesWithAlt) {
        super(useVisualBounds, preserveAux);
        this.pageSize = pageSize;
        this.useVisualBounds = useVisualBounds;
        this.preserveAux = preserveAux;
        this.replaceImagesWithAlt = replaceImagesWithAlt;
        this.includeScreenshot = true;
        this.zoom = 1.0f;
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float zoom) {
        this.zoom = zoom;
    }

    public boolean getAcquireImages() {
        return this.acquireImages;
    }

    public void setAcquireImages(boolean acquireImages) {
        this.acquireImages = acquireImages;
    }

    public boolean getIncludeScreenshot() {
        return this.includeScreenshot;
    }

    public void setIncludeScreenshot(boolean includeScreenshot) {
        this.includeScreenshot = includeScreenshot;
    }

    public void setPageIri(IRI pageIri) {
        if (this.page != null) {
            this.page.setIri(pageIri);
        }
    }

    public void parse(URL url) throws IOException, SAXException {
        Engine engine = this.renderUrl(url, this.pageSize);
        this.viewport = engine.getViewport();
        PageImpl pg = this.page = new PageImpl(this.pageUrl);
        pg.setTitle(this.pageTitle);
        if (this.includeScreenshot) {
            BufferedImage img = ((GraphicsEngine)engine).getImage();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)img, "png", baos);
            pg.setPngImage(baos.toByteArray());
        }
        Viewport rootbox = engine.getViewport();
        Box root = this.buildTree(rootbox);
        pg.setRoot(root);
        pg.setWidth(root.getWidth());
        pg.setHeight(root.getHeight());
    }

    public void parseList(List<URL> list) throws IOException, SAXException {
        int twidth = 0;
        int theight = 0;
        this.page = new PageImpl(list.get(0));
        DefaultBox main = new DefaultBox();
        main.setPage((Page)this.page);
        main.setTagName("pageset");
        for (URL url : list) {
            log.info("Parsing: {}", (Object)url);
            Engine engine = this.renderUrl(url, this.pageSize);
            Viewport rootbox = engine.getViewport();
            Box root = this.buildTree(rootbox);
            DefaultBox pageBox = new DefaultBox();
            pageBox.setPageIri(this.page.getIri());
            pageBox.appendChild((GenericTreeNode)root);
            pageBox.setTagName("page");
            pageBox.setDisplayType(Box.DisplayType.BLOCK);
            pageBox.setBounds(new Rectangular(root.getBounds()));
            pageBox.setVisualBounds(new Rectangular(root.getBounds()));
            pageBox.setContentBounds(new Rectangular(root.getBounds()));
            pageBox.move(0, theight);
            pageBox.setBackgroundSeparated(true);
            log.info("Rendered: {}x{}", (Object)pageBox.getWidth(), (Object)pageBox.getHeight());
            main.appendChild((GenericTreeNode)pageBox);
            twidth = Math.max(twidth, pageBox.getWidth());
            theight += pageBox.getHeight();
        }
        main.setBounds(new Rectangular(0, 0, twidth, theight));
        main.setVisualBounds(new Rectangular(0, 0, twidth, theight));
        this.page.setRoot((Box)main);
        this.page.setWidth(twidth);
        this.page.setHeight(theight);
    }

    public void parse(String urlstring) throws MalformedURLException, IOException, SAXException {
        if ((urlstring = urlstring.trim()).startsWith("http:") || urlstring.startsWith("https:") || urlstring.startsWith("ftp:") || urlstring.startsWith("file:")) {
            this.parse(new URL(urlstring));
        } else if (urlstring.startsWith("list:")) {
            List<URL> list = this.loadList(urlstring.substring(5));
            this.parseList(list);
        } else {
            throw new MalformedURLException("Unsupported protocol in " + urlstring);
        }
    }

    public Page getPage() {
        return this.page;
    }

    protected Engine renderUrl(URL url, Dimension pageSize) throws IOException, SAXException {
        int p;
        DefaultDocumentSource src = new DefaultDocumentSource(url);
        this.pageUrl = src.getURL();
        InputStream is = src.getInputStream();
        String mime = src.getContentType();
        if (mime == null) {
            mime = "text/html";
        }
        if ((p = mime.indexOf(59)) != -1) {
            mime = mime.substring(0, p).trim();
        }
        log.info("File type: " + mime);
        if (mime.equals("application/pdf")) {
            PDDocument doc = this.loadPdf(is);
            PdfEngine engine = new PdfEngine(doc, null, pageSize, src.getURL());
            doc.close();
            this.pageTitle = "";
            return engine;
        }
        DefaultDOMSource parser = new DefaultDOMSource((DocumentSource)src);
        Document doc = parser.parse();
        this.pageTitle = this.findPageTitle(doc);
        String encoding = parser.getCharset();
        MediaSpec media = new MediaSpec("screen");
        DOMAnalyzer da = new DOMAnalyzer(doc, src.getURL());
        if (encoding == null) {
            encoding = da.getCharacterEncoding();
        }
        da.setDefaultEncoding(encoding);
        da.setMediaSpec(media);
        da.attributesToStyles();
        da.addStyleSheet(null, CSSNorm.stdStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.userStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.addStyleSheet(null, CSSNorm.formsStyleSheet(), DOMAnalyzer.Origin.AGENT);
        da.getStyleSheets();
        GraphicsEngine engine = new GraphicsEngine(da.getRoot(), da, src.getURL());
        engine.setAutoMediaUpdate(false);
        engine.getConfig().setLoadImages(this.acquireImages);
        engine.getConfig().setLoadBackgroundImages(this.acquireImages);
        engine.getConfig().setLoadFonts(false);
        engine.getConfig().setReplaceImagesWithAlt(this.replaceImagesWithAlt);
        this.defineLogicalFonts(engine.getConfig());
        engine.createLayout(pageSize, new Rectangle(pageSize), this.includeScreenshot);
        src.close();
        return engine;
    }

    protected void defineLogicalFonts(BrowserConfig config) {
        config.setLogicalFont("serif", Arrays.asList("Times", "Times New Roman"));
        config.setLogicalFont("sans-serif", Arrays.asList("Arial", "Helvetica"));
        config.setLogicalFont("monospace", Arrays.asList("Courier New", "Courier"));
    }

    private PDDocument loadPdf(InputStream is) throws IOException {
        PDDocument document = null;
        document = PDDocument.load((InputStream)is);
        return document;
    }

    private String findPageTitle(Document doc) {
        Element head;
        NodeList titles;
        NodeList heads = doc.getElementsByTagName("head");
        if (heads.getLength() > 0 && (titles = (head = (Element)heads.item(0)).getElementsByTagName("title")).getLength() > 0) {
            String ret = titles.item(0).getTextContent();
            return ret == null ? null : ret.trim();
        }
        return "";
    }

    protected Box buildTree(Viewport vp) {
        log.trace("LIST");
        List<Box> boxlist = this.createBoxList(vp);
        Color bg = Units.toColor(vp.getBgcolor());
        if (bg == null) {
            bg = Color.WHITE;
        }
        Box root = this.buildTree(boxlist, bg);
        return root;
    }

    private List<Box> createBoxList(Viewport vp) {
        BoxListRenderer renderer = new BoxListRenderer((Page)this.page, this.zoom);
        renderer.init(vp);
        vp.draw((BoxRenderer)renderer);
        List<Box> ret = renderer.getBoxList();
        this.findIntrinsicParents(ret);
        return ret;
    }

    private void findIntrinsicParents(List<Box> boxes) {
        HashMap<org.fit.cssbox.layout.Box, Box> srcBoxes = new HashMap<org.fit.cssbox.layout.Box, Box>();
        for (Box box : boxes) {
            srcBoxes.put(((BoxNode)box).getBox(), box);
        }
        for (Box box : boxes) {
            Box parent;
            BoxNode node = (BoxNode)box;
            if (node.getBox() == null || node.getBox().getParent() == null || (parent = (Box)srcBoxes.get(node.getBox().getParent())) == null) continue;
            node.setIntrinsicParent(parent);
        }
    }

    private List<URL> loadList(String filename) {
        ArrayList<URL> ret = new ArrayList<URL>();
        try {
            String line;
            BufferedReader read = new BufferedReader(new FileReader(filename));
            while ((line = read.readLine()) != null) {
                if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                ret.add(new URL(line));
            }
            read.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return ret;
    }
}

