package de.adorsys.datasafe.directory.impl.profile.dfs;

import dagger.Lazy;
import de.adorsys.datasafe.directory.api.profile.keys.StorageKeyStoreOperations;
import de.adorsys.datasafe.encrypiton.api.types.UserID;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.AbsoluteLocation;
import de.adorsys.datasafe.types.api.resource.PrivateResource;
import de.adorsys.datasafe.types.api.resource.PublicResource;
import java.lang.Override;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class RegexAccessServiceWithStorageCredentialsImplRuntimeDelegatable extends RegexAccessServiceWithStorageCredentialsImpl {
    private final RegexAccessServiceWithStorageCredentialsImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public RegexAccessServiceWithStorageCredentialsImplRuntimeDelegatable(
            @Nullable OverridesRegistry context,
            Lazy<StorageKeyStoreOperations> storageKeyStoreOperations) {
        super(storageKeyStoreOperations);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(storageKeyStoreOperations);
        delegate = context != null ? context.findOverride(RegexAccessServiceWithStorageCredentialsImpl.class, argumentsCaptor) : null;
    }

    @Override
    public AbsoluteLocation<PrivateResource> privateAccessFor(UserIDAuth user,
            PrivateResource resource) {
        if (null == delegate) {
            return super.privateAccessFor(user, resource);
        } else {
            return delegate.privateAccessFor(user, resource);
        }
    }

    @Override
    public AbsoluteLocation<PublicResource> publicAccessFor(UserID user, PublicResource resource) {
        if (null == delegate) {
            return super.publicAccessFor(user, resource);
        } else {
            return delegate.publicAccessFor(user, resource);
        }
    }

    @Override
    public AbsoluteLocation withSystemAccess(AbsoluteLocation resource) {
        if (null == delegate) {
            return super.withSystemAccess(resource);
        } else {
            return delegate.withSystemAccess(resource);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, RegexAccessServiceWithStorageCredentialsImpl> ctorCaptor) {
        context.override(RegexAccessServiceWithStorageCredentialsImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final Lazy<StorageKeyStoreOperations> storageKeyStoreOperations;

        private ArgumentsCaptor(Lazy<StorageKeyStoreOperations> storageKeyStoreOperations) {
            this.storageKeyStoreOperations = storageKeyStoreOperations;
        }

        public Lazy<StorageKeyStoreOperations> getStorageKeyStoreOperations() {
            return storageKeyStoreOperations;
        }
    }
}
