package de.adorsys.datasafe.directory.impl.profile.keys;

import de.adorsys.datasafe.directory.api.profile.dfs.BucketAccessService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.types.StorageCredentials;
import de.adorsys.datasafe.directory.impl.profile.serde.GsonSerde;
import de.adorsys.datasafe.encrypiton.api.keystore.KeyStoreService;
import de.adorsys.datasafe.encrypiton.api.types.UserIDAuth;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import de.adorsys.datasafe.types.api.resource.StorageIdentifier;
import de.adorsys.datasafe.types.api.types.ReadKeyPassword;
import java.lang.Override;
import java.security.KeyStore;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class StorageKeyStoreOperationsImplRuntimeDelegatable extends StorageKeyStoreOperationsImpl {
    private final StorageKeyStoreOperationsImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public StorageKeyStoreOperationsImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            GsonSerde gson, KeyStoreService keyStoreService, GenericKeystoreOperations genericOper,
            ProfileRetrievalService profile, BucketAccessService access,
            KeyStoreCache keystoreCache) {
        super(gson, keyStoreService, genericOper, profile, access, keystoreCache);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(gson, keyStoreService, genericOper, profile, access, keystoreCache);
        delegate = context != null ? context.findOverride(StorageKeyStoreOperationsImpl.class, argumentsCaptor) : null;
    }

    @Override
    public StorageCredentials getStorageCredentials(UserIDAuth forUser, StorageIdentifier id) {
        if (null == delegate) {
            return super.getStorageCredentials(forUser, id);
        } else {
            return delegate.getStorageCredentials(forUser, id);
        }
    }

    @Override
    public Set<StorageIdentifier> readAliases(UserIDAuth forUser) {
        if (null == delegate) {
            return super.readAliases(forUser);
        } else {
            return delegate.readAliases(forUser);
        }
    }

    @Override
    public void updateReadKeyPassword(UserIDAuth forUser, ReadKeyPassword newPassword) {
        if (null == delegate) {
            super.updateReadKeyPassword(forUser, newPassword);
        } else {
            delegate.updateReadKeyPassword(forUser, newPassword);
        }
    }

    @Override
    public void createAndWriteKeystore(UserIDAuth forUser) {
        if (null == delegate) {
            super.createAndWriteKeystore(forUser);
        } else {
            delegate.createAndWriteKeystore(forUser);
        }
    }

    @Override
    public void addStorageCredentials(UserIDAuth forUser, StorageIdentifier storageId,
            StorageCredentials credentials) {
        if (null == delegate) {
            super.addStorageCredentials(forUser, storageId, credentials);
        } else {
            delegate.addStorageCredentials(forUser, storageId, credentials);
        }
    }

    @Override
    public void removeStorageCredentials(UserIDAuth forUser, StorageIdentifier storageId) {
        if (null == delegate) {
            super.removeStorageCredentials(forUser, storageId);
        } else {
            delegate.removeStorageCredentials(forUser, storageId);
        }
    }

    @Override
    public void invalidateCache(UserIDAuth forUser) {
        if (null == delegate) {
            super.invalidateCache(forUser);
        } else {
            delegate.invalidateCache(forUser);
        }
    }

    @Override
    protected KeyStore newKeystore(UserIDAuth forUser) {
        if (null == delegate) {
            return super.newKeystore(forUser);
        } else {
            return delegate.newKeystore(forUser);
        }
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, StorageKeyStoreOperationsImpl> ctorCaptor) {
        context.override(StorageKeyStoreOperationsImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final GsonSerde gson;

        private final KeyStoreService keyStoreService;

        private final GenericKeystoreOperations genericOper;

        private final ProfileRetrievalService profile;

        private final BucketAccessService access;

        private final KeyStoreCache keystoreCache;

        private ArgumentsCaptor(GsonSerde gson, KeyStoreService keyStoreService,
                GenericKeystoreOperations genericOper, ProfileRetrievalService profile,
                BucketAccessService access, KeyStoreCache keystoreCache) {
            this.gson = gson;
            this.keyStoreService = keyStoreService;
            this.genericOper = genericOper;
            this.profile = profile;
            this.access = access;
            this.keystoreCache = keystoreCache;
        }

        public GsonSerde getGson() {
            return gson;
        }

        public KeyStoreService getKeyStoreService() {
            return keyStoreService;
        }

        public GenericKeystoreOperations getGenericOper() {
            return genericOper;
        }

        public ProfileRetrievalService getProfile() {
            return profile;
        }

        public BucketAccessService getAccess() {
            return access;
        }

        public KeyStoreCache getKeystoreCache() {
            return keystoreCache;
        }
    }
}
