package de.adorsys.datasafe.directory.impl.profile.operations;

import de.adorsys.datasafe.directory.api.profile.operations.ProfileRegistrationService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRemovalService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileRetrievalService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileStorageCredentialsService;
import de.adorsys.datasafe.directory.api.profile.operations.ProfileUpdatingService;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class DFSBasedProfileStorageImplRuntimeDelegatable extends DFSBasedProfileStorageImpl {
    private final DFSBasedProfileStorageImpl delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public DFSBasedProfileStorageImplRuntimeDelegatable(@Nullable OverridesRegistry context,
            ProfileRegistrationService registrationService,
            ProfileRetrievalService retrievalService, ProfileRemovalService removalService,
            ProfileUpdatingService updatingService,
            ProfileStorageCredentialsService storageCredentialsService) {
        super(registrationService, retrievalService, removalService, updatingService, storageCredentialsService);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(registrationService, retrievalService, removalService, updatingService, storageCredentialsService);
        delegate = context != null ? context.findOverride(DFSBasedProfileStorageImpl.class, argumentsCaptor) : null;
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, DFSBasedProfileStorageImpl> ctorCaptor) {
        context.override(DFSBasedProfileStorageImpl.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final ProfileRegistrationService registrationService;

        private final ProfileRetrievalService retrievalService;

        private final ProfileRemovalService removalService;

        private final ProfileUpdatingService updatingService;

        private final ProfileStorageCredentialsService storageCredentialsService;

        private ArgumentsCaptor(ProfileRegistrationService registrationService,
                ProfileRetrievalService retrievalService, ProfileRemovalService removalService,
                ProfileUpdatingService updatingService,
                ProfileStorageCredentialsService storageCredentialsService) {
            this.registrationService = registrationService;
            this.retrievalService = retrievalService;
            this.removalService = removalService;
            this.updatingService = updatingService;
            this.storageCredentialsService = storageCredentialsService;
        }

        public ProfileRegistrationService getRegistrationService() {
            return registrationService;
        }

        public ProfileRetrievalService getRetrievalService() {
            return retrievalService;
        }

        public ProfileRemovalService getRemovalService() {
            return removalService;
        }

        public ProfileUpdatingService getUpdatingService() {
            return updatingService;
        }

        public ProfileStorageCredentialsService getStorageCredentialsService() {
            return storageCredentialsService;
        }
    }
}
