package de.adorsys.datasafe.directory.impl.profile.serde;

import de.adorsys.datasafe.encrypiton.api.keystore.PublicKeySerde;
import de.adorsys.datasafe.types.api.context.overrides.OverridesRegistry;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nullable;
import javax.inject.Inject;

@Generated(
        value = "de.adorsys.datasafe.runtimedelegate.RuntimeDelegateGenerator",
        comments = "This class performs functionality delegation based on contextClass content. If contextClass contains overriding class - it will be used."
)
public class GsonSerdeRuntimeDelegatable extends GsonSerde {
    private final GsonSerde delegate;

    /**
     * @param context Context class to search for overrides.
     */
    @Inject
    public GsonSerdeRuntimeDelegatable(@Nullable OverridesRegistry context,
            PublicKeySerde pubSerde) {
        super(pubSerde);
        ArgumentsCaptor argumentsCaptor = new ArgumentsCaptor(pubSerde);
        delegate = context != null ? context.findOverride(GsonSerde.class, argumentsCaptor) : null;
    }

    /**
     * This is a typesafe function to register overriding class into context.
     */
    public static void overrideWith(OverridesRegistry context,
            Function<ArgumentsCaptor, GsonSerde> ctorCaptor) {
        context.override(GsonSerde.class, args -> ctorCaptor.apply((ArgumentsCaptor) args));
    }

    public static class ArgumentsCaptor {
        private final PublicKeySerde pubSerde;

        private ArgumentsCaptor(PublicKeySerde pubSerde) {
            this.pubSerde = pubSerde;
        }

        public PublicKeySerde getPubSerde() {
            return pubSerde;
        }
    }
}
