/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.lockpersistence.client;

import de.adorsys.lockpersistence.client.LockClient;
import de.adorsys.lockpersistence.model.Lock;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class LockClientTemplate
implements LockClient {
    protected Logger logger = Logger.getLogger(this.getClass().getName());
    private String applicationName;
    private Map<String, String> ownedLocks = new ConcurrentHashMap<String, String>();

    public LockClientTemplate(String applicationName) {
        this.applicationName = applicationName;
    }

    @Override
    public void executeIfOwned(Runnable runnable) {
        this.executeIfOwned(this.applicationName, runnable);
    }

    @Override
    public void executeIfOwned(String lockKey, Runnable runnable) {
        try {
            Lock lock = this.lookupLock(lockKey);
            if (this.isLockOwned(lock)) {
                runnable.run();
            }
        }
        catch (Exception ex) {
            this.logger.log(Level.ALL, "Error while refreshing lock " + lockKey + ". Message : " + ex.getMessage());
        }
    }

    protected abstract Iterable<Lock> locks();

    private synchronized Lock lookupLock(String lockKey) {
        for (Lock lock : this.locks()) {
            if (!lock.getName().equals(lockKey)) continue;
            if (lock.getExpires().getTime() - new Date().getTime() < 0L) {
                this.releaseAndDestoreLock(lock);
                continue;
            }
            if (this.isLockOwned(lock)) {
                return this.refreshAndStoreLock(lock);
            }
            return lock;
        }
        return this.createAndStoreLock(lockKey);
    }

    protected abstract Lock create(String var1);

    private Lock createAndStoreLock(String name) {
        Lock lock = this.create(name);
        this.ownedLocks.put(lock.getName(), lock.getValue());
        return lock;
    }

    private boolean isLockOwned(Lock lock) {
        String ownedLockValue = this.ownedLocks.get(lock.getName());
        return ownedLockValue != null && ownedLockValue.equals(lock.getValue());
    }

    protected abstract Lock refresh(String var1, String var2);

    private Lock refreshAndStoreLock(Lock lock) {
        Lock refreshedLock = this.refresh(lock.getName(), lock.getValue());
        this.ownedLocks.put(lock.getName(), lock.getValue());
        return refreshedLock;
    }

    protected abstract void release(String var1, String var2);

    private void releaseAndDestoreLock(Lock lock) {
        this.ownedLocks.remove(lock.getName());
        try {
            this.release(lock.getName(), lock.getValue());
        }
        catch (Exception ex) {
            this.logger.log(Level.ALL, "Error while release lock " + lock.getName() + ". Message : " + ex.getMessage());
        }
    }
}

