/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.tokenstore.mongodb;

import com.nimbusds.oauth2.sdk.AuthorizationCode;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Token;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.util.Calendar;
import java.util.Date;
import net.minidev.json.JSONObject;
import org.bson.Document;

public class TokenDocument {
    private String id;
    private Date created;
    private String token;
    private String userInfo;
    private Date expires;
    private String authCode;

    public TokenDocument() {
    }

    public TokenDocument(Token token, UserInfo userInfo) {
        this.id = token.getValue();
        this.token = token.toJSONObject().toJSONString();
        this.created = new Date();
        if (token instanceof AccessToken && 0L != ((AccessToken)token).getLifetime()) {
            Calendar cal = Calendar.getInstance();
            cal.add(13, (int)((AccessToken)token).getLifetime());
            this.expires = cal.getTime();
        }
        if (userInfo != null) {
            this.userInfo = userInfo.toJSONObject().toJSONString();
        }
    }

    public TokenDocument(Token token, UserInfo userInfo, AuthorizationCode authCode) {
        this(token, userInfo);
        this.authCode = authCode != null ? authCode.getValue() : null;
    }

    public Document asDocument() {
        Document document = new Document("_id", (Object)this.id).append("token", (Object)this.token).append("created", (Object)this.created).append("userInfo", (Object)this.userInfo);
        if (this.expires != null) {
            document.append("expires", (Object)this.expires);
        }
        if (this.authCode != null) {
            document.append("authCode", (Object)this.authCode);
        }
        return document;
    }

    public static TokenDocument from(Document document) {
        TokenDocument tokenDocument = new TokenDocument();
        tokenDocument.id = document.getString((Object)"id");
        tokenDocument.token = document.getString((Object)"token");
        tokenDocument.userInfo = document.getString((Object)"userInfo");
        tokenDocument.authCode = document.getString((Object)"authCode");
        tokenDocument.created = document.getDate((Object)"created");
        tokenDocument.expires = document.getDate((Object)"expires");
        return tokenDocument;
    }

    public AccessToken asAccessToken() {
        try {
            return BearerAccessToken.parse((JSONObject)this.getJSONObject(this.token));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public RefreshToken asRefreshToken() {
        try {
            return RefreshToken.parse((JSONObject)this.getJSONObject(this.token));
        }
        catch (Exception exception) {
            return null;
        }
    }

    private JSONObject getJSONObject(String value) {
        if (value == null) {
            return null;
        }
        try {
            return JSONObjectUtils.parse((String)value);
        }
        catch (ParseException e) {
            throw new IllegalStateException("invalid content " + e.getMessage());
        }
    }

    public boolean isValid() {
        AccessToken accessToken = this.asAccessToken();
        if (accessToken != null) {
            return this.expires == null || System.currentTimeMillis() < this.expires.getTime();
        }
        return this.asRefreshToken() != null;
    }

    public String toString() {
        return this.expires != null ? String.format("%1$Td.%1$Tm.%1$Ty-%1$TT.%1$TL %2$s", this.expires, this.token) : this.token;
    }

    public UserInfo getUserInfo() {
        return this.userInfo == null ? null : new UserInfo(this.getJSONObject(this.userInfo));
    }

    public String getJsonUserInfo() {
        return this.userInfo;
    }

    public String getAuthCode() {
        return this.authCode;
    }
}

