/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.psd2.report.jpa.builder;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Objects;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.stereotype.Component;

@Component
public class SqlEventReportBuilder
extends MapSqlParameterSource {
    private static final Logger log = LoggerFactory.getLogger(SqlEventReportBuilder.class);
    private static final String PLACEHOLDER = "<schema_name>";
    @Value(value="${spring.jpa.properties.hibernate.default_schema}")
    private String schemaName;
    @Value(value="base_event_report_db.sql")
    private String sqlRequestFileName;
    private StringBuilder sqlRequest;
    private StringBuilder filterRequest;

    public String getBasePartOfRequest() throws IOException {
        return IOUtils.toString((InputStream)Objects.requireNonNull(((Object)((Object)this)).getClass().getClassLoader().getResource(this.sqlRequestFileName)).openStream(), (Charset)Charset.defaultCharset()).replace(PLACEHOLDER, this.schemaName);
    }

    public SqlEventReportBuilder baseRequest() {
        try {
            this.sqlRequest = new StringBuilder(this.getBasePartOfRequest());
        }
        catch (IOException e) {
            log.error("Request query was not found!");
        }
        this.filterRequest = new StringBuilder();
        return this;
    }

    public SqlEventReportBuilder period() {
        this.appendToRequest("timestamp between :periodFrom and :periodTo ");
        return this;
    }

    public SqlEventReportBuilder instanceId() {
        this.appendToRequest("ev.instance_id = :instanceId ");
        return this;
    }

    public SqlEventReportBuilder consentId() {
        this.appendToRequest("ev.consent_id = :consentId ");
        return this;
    }

    public SqlEventReportBuilder paymentId() {
        this.appendToRequest("ev.payment_id = :paymentId ");
        return this;
    }

    public SqlEventReportBuilder eventType() {
        this.appendToRequest("ev.event_type = :eventType ");
        return this;
    }

    public SqlEventReportBuilder eventOrigin() {
        this.appendToRequest("ev.event_origin = :eventOrigin ");
        return this;
    }

    public String build() {
        return this.sqlRequest.append((CharSequence)this.filterRequest).append("order by timestamp ").toString();
    }

    private void appendToRequest(String filter) {
        if (this.filterRequest.length() == 0) {
            this.filterRequest.append("where ");
        } else {
            this.filterRequest.append("and  ");
        }
        this.filterRequest.append(filter);
    }
}

