/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10;

import de.agilecoders.wicket.extensions.markup.html.bootstrap.WicketApplicationTest;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.DataSet;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.Source;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.Typeahead;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.TypeaheadConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.Bloodhound;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.BloodhoundConfig;
import de.agilecoders.wicket.extensions.markup.html.bootstrap.form.typeaheadV10.bloodhound.Remote;
import java.io.Serializable;
import java.util.Collections;
import org.apache.wicket.Component;
import org.apache.wicket.markup.IMarkupFragment;
import org.apache.wicket.markup.Markup;
import org.apache.wicket.markup.head.OnDomReadyHeaderItem;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.tester.WicketTester;
import org.junit.Test;

public class TypeaheadConfigTest
extends WicketApplicationTest {
    @Test
    public void assertValidHeaderScript() {
        WicketTester tester = this.tester();
        Bloodhound bloodhound = new Bloodhound("engine", new BloodhoundConfig()){

            public Iterable getChoices(String input) {
                return Collections.EMPTY_LIST;
            }

            public String renderChoice(Object choice) {
                return null;
            }
        };
        DataSet dataSet = new DataSet((Source)bloodhound);
        TypeaheadConfig config = new TypeaheadConfig(dataSet, new DataSet[0]);
        Typeahead field = new Typeahead("typeahead", (IModel)Model.of((Serializable)((Object)"")), config);
        tester.startComponentInPage((Component)field, (IMarkupFragment)Markup.of((String)"<html><head></head><body><input type='text' wicket:id='typeahead'/></body></html>"));
        OnDomReadyHeaderItem item = field.getDomReadyScript(config);
        String expected = "var engine = new Bloodhound({\"datumTokenizer\":function(d) { return Bloodhound.tokenizers.whitespace(d.value); },\"queryTokenizer\":Bloodhound.tokenizers.whitespace,\"remote\":\"./wicket/page?0-1.IBehaviorListener.0-typeahead&term=%QUERY\"});engine.initialize();$('#typeahead1').typeahead({},{\"name\":\"engine\",\"source\":engine.ttAdapter()});";
        TypeaheadConfigTest.assertEquals((Object)expected, (Object)item.getJavaScript());
    }

    @Test
    public void testComplexRemote() {
        Remote remote = new Remote();
        remote.withUrl((CharSequence)"foo").withWildcard("%FOO");
        BloodhoundConfig config = new BloodhoundConfig();
        config.withRemote(remote);
        String expected = "{\"datumTokenizer\":function(d) { return Bloodhound.tokenizers.whitespace(d.value); },\"queryTokenizer\":Bloodhound.tokenizers.whitespace,\"remote\":\"{\\\"url\\\":\\\"foo\\\",\\\"wildcard\\\":\\\"%FOO\\\"}\"}";
        TypeaheadConfigTest.assertEquals((Object)expected, (Object)config.toJsonString());
    }

    @Test
    public void testSimpleRemote() {
        Remote remote = new Remote((CharSequence)"foo");
        BloodhoundConfig config = new BloodhoundConfig();
        config.withRemote(remote);
        String expected = "{\"datumTokenizer\":function(d) { return Bloodhound.tokenizers.whitespace(d.value); },\"queryTokenizer\":Bloodhound.tokenizers.whitespace,\"remote\":\"foo\"}";
        TypeaheadConfigTest.assertEquals((Object)expected, (Object)config.toJsonString());
    }
}

