/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.extensions.markup.html.bootstrap.form;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import de.agilecoders.wicket.core.util.Dates;
import de.agilecoders.wicket.jquery.AbstractConfig;
import de.agilecoders.wicket.jquery.IKey;
import java.io.IOException;
import org.joda.time.DateTime;

public class DateTextFieldConfig
extends AbstractConfig {
    private static final IKey<String> StartDate = DateTextFieldConfig.newKey((String)"startDate", null);
    private static final IKey<String> EndDate = DateTextFieldConfig.newKey((String)"endDate", null);
    private static final IKey<Integer> StartView = DateTextFieldConfig.newKey((String)"startView", (Object)0);
    private static final IKey<TodayButton> ShowTodayButton = DateTextFieldConfig.newKey((String)"todayBtn", (Object)((Object)TodayButton.FALSE));
    private static final IKey<Boolean> KeyboardNavigation = DateTextFieldConfig.newKey((String)"keyboardNavigation", (Object)true);
    private static final IKey<String> Language = DateTextFieldConfig.newKey((String)"language", (Object)"en");
    private static final IKey<String> Format = DateTextFieldConfig.newKey((String)"format", (Object)"mm/dd/yyyy");
    private static final IKey<Integer> WeekStart = DateTextFieldConfig.newKey((String)"weekStart", (Object)0);
    private static final IKey<Boolean> HighlightToday = DateTextFieldConfig.newKey((String)"todayHighlight", (Object)false);
    private static final IKey<Boolean> AutoClose = DateTextFieldConfig.newKey((String)"autoclose", (Object)false);
    private static final IKey<Boolean> ForceParse = DateTextFieldConfig.newKey((String)"forceParse", (Object)true);

    public String getFormat() {
        return Dates.toJavaDateFormat((String)this.getString(Format));
    }

    public String getLanguage() {
        return this.getString(Language);
    }

    public boolean isDefaultLanguageSet() {
        return Language.isDefaultValue((Object)this.getLanguage());
    }

    public DateTextFieldConfig withStartDate(DateTime value) {
        this.put(StartDate, value.toString());
        return this;
    }

    public DateTextFieldConfig withEndDate(DateTime value) {
        this.put(EndDate, value.toString());
        return this;
    }

    public DateTextFieldConfig withLanguage(String value) {
        this.put(Language, value);
        return this;
    }

    public DateTextFieldConfig withView(View value) {
        this.put(StartView, value.ordinal());
        return this;
    }

    public DateTextFieldConfig withFormat(String value) {
        this.put(Format, Dates.toJavaScriptDateFormat((String)value));
        return this;
    }

    public DateTextFieldConfig withWeekStart(Day value) {
        this.put(WeekStart, value.ordinal());
        return this;
    }

    public DateTextFieldConfig allowKeyboardNavigation(boolean value) {
        this.put(KeyboardNavigation, value);
        return this;
    }

    public DateTextFieldConfig highlightToday(boolean value) {
        this.put(HighlightToday, value);
        return this;
    }

    public DateTextFieldConfig showTodayButton(TodayButton value) {
        this.put(ShowTodayButton, (Object)value);
        return this;
    }

    public DateTextFieldConfig forceParse(boolean value) {
        this.put(ForceParse, value);
        return this;
    }

    public DateTextFieldConfig autoClose(boolean value) {
        this.put(AutoClose, value);
        return this;
    }

    private static class TodayButtonSerializer
    extends JsonSerializer<TodayButton> {
        private TodayButtonSerializer() {
        }

        public void serialize(TodayButton value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
            switch (value) {
                case TRUE: {
                    jgen.writeBoolean(true);
                    break;
                }
                case FALSE: {
                    jgen.writeBoolean(false);
                    break;
                }
                case LINKED: {
                    jgen.writeString("linked");
                }
            }
        }
    }

    @JsonSerialize(using=TodayButtonSerializer.class)
    public static enum TodayButton {
        TRUE,
        FALSE,
        LINKED;

    }

    public static enum View {
        Month,
        Year,
        Decade;

    }

    public static enum Day {
        Sunday,
        Monday,
        Tuesday,
        Wednesday,
        Thursday,
        Friday,
        Saturday;

    }
}

