/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import de.agilecoders.wicket.less.LessResourceStream;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import javax.servlet.ServletContext;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.request.resource.AbstractResource;
import org.apache.wicket.request.resource.ContextRelativeResource;
import org.apache.wicket.request.resource.IResource;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.io.Streams;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;

public class ContextRelativeLessResource
extends ContextRelativeResource {
    private final String path;

    public ContextRelativeLessResource(String path) {
        super(path);
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        this.path = path;
    }

    protected AbstractResource.ResourceResponse newResourceResponse(IResource.Attributes attributes) {
        AbstractResource.ResourceResponse resourceResponse = new AbstractResource.ResourceResponse();
        try {
            ServletContext context = WebApplication.get().getServletContext();
            URL resourceURL = context.getResource(this.path);
            if (resourceURL == null) {
                throw new FileNotFoundException("Unable to find resource '" + this.path + "' in the servlet context");
            }
            UrlResourceStream urlResourceStream = new UrlResourceStream(resourceURL);
            final LessResourceStream webExternalResourceStream = new LessResourceStream((IResourceStream)urlResourceStream, ContextRelativeLessResource.class.getName());
            resourceResponse.setContentType(webExternalResourceStream.getContentType());
            resourceResponse.setLastModified(webExternalResourceStream.lastModifiedTime());
            resourceResponse.setFileName(this.path);
            resourceResponse.setWriteCallback(new AbstractResource.WriteCallback(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void writeData(IResource.Attributes attributes) throws IOException {
                    try {
                        InputStream inputStream = webExternalResourceStream.getInputStream();
                        try {
                            Streams.copy((InputStream)inputStream, (OutputStream)attributes.getResponse().getOutputStream());
                        }
                        finally {
                            IOUtils.closeQuietly((Closeable)inputStream);
                        }
                    }
                    catch (ResourceStreamNotFoundException rsnfx) {
                        throw new WicketRuntimeException((Throwable)rsnfx);
                    }
                }
            });
            return resourceResponse;
        }
        catch (IOException iox) {
            throw new WicketRuntimeException((Throwable)iox);
        }
    }
}

