/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.LessSource;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import de.agilecoders.wicket.less.LessCompilerConfigurationFactory;
import de.agilecoders.wicket.less.LessUrlSource;
import de.agilecoders.wicket.less.SimpleLessCompilerConfigurationFactory;
import java.io.IOException;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.io.Connections;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(LessCacheManager.class);
    private static final MetaDataKey<LessCacheManager> KEY = new MetaDataKey<LessCacheManager>(){
        private static final long serialVersionUID = 1L;
    };
    private final ConcurrentMap<URL, LessSource.URLSource> urlSourceCache = new ConcurrentHashMap<URL, LessSource.URLSource>();
    private final ConcurrentMap<LessSource.URLSource, ConcurrentMap<Time, String>> contentCache = new ConcurrentHashMap<LessSource.URLSource, ConcurrentMap<Time, String>>();
    private final LessCompilerConfigurationFactory configFactory;

    public LessCacheManager(LessCompilerConfigurationFactory configFactory) {
        this.configFactory = configFactory != null ? configFactory : new SimpleLessCompilerConfigurationFactory();
    }

    public LessCacheManager() {
        this(null);
    }

    public LessSource.URLSource getLessSource(URL lessUrl, String scopeClass) {
        LessUrlSource lessSource = new LessUrlSource(lessUrl, scopeClass);
        LessSource.URLSource oldValue = this.urlSourceCache.putIfAbsent(lessUrl, lessSource);
        if (oldValue != null) {
            lessSource = oldValue;
        }
        return lessSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCss(LessSource.URLSource lessSource) {
        Time lastModifiedTime;
        String cssContent;
        ConcurrentMap old;
        ConcurrentMap<Time, String> timeToContentMap = (ConcurrentHashMap)this.contentCache.get(lessSource);
        if (timeToContentMap == null && (old = (ConcurrentMap)this.contentCache.putIfAbsent(lessSource, timeToContentMap = new ConcurrentHashMap())) != null) {
            timeToContentMap = old;
        }
        if ((cssContent = (String)timeToContentMap.get(lastModifiedTime = this.getLastModifiedTime(lessSource))) == null) {
            LessSource.URLSource uRLSource = lessSource;
            synchronized (uRLSource) {
                lastModifiedTime = this.getLastModifiedTime(lessSource);
                cssContent = (String)timeToContentMap.get(lastModifiedTime);
                if (cssContent == null) {
                    timeToContentMap.clear();
                    ThreadUnsafeLessCompiler compiler = new ThreadUnsafeLessCompiler();
                    LessCompiler.Configuration configuration = this.configFactory.newConfiguration();
                    configuration.getSourceMapConfiguration().setLinkSourceMap(false);
                    try {
                        LessCompiler.CompilationResult result = compiler.compile((LessSource)lessSource, configuration);
                        List warnings = result.getWarnings();
                        for (LessCompiler.Problem warning : warnings) {
                            LOG.warn("There is a warning during compilation of '{}' at line {}, character {}. Message: {}", new Object[]{lessSource.getInputURL(), warning.getLine(), warning.getCharacter(), warning.getMessage()});
                        }
                        cssContent = result.getCss();
                        lastModifiedTime = this.getLastModifiedTime(lessSource);
                        timeToContentMap.put(lastModifiedTime, cssContent);
                    }
                    catch (Less4jException x) {
                        throw new WicketRuntimeException("An error occurred while compiling Less resource " + lessSource.getInputURL().toExternalForm(), (Throwable)x);
                    }
                }
            }
        }
        return cssContent;
    }

    public Time getLastModifiedTime(LessSource.URLSource lessSource) {
        Time modified = Time.START_OF_UNIX_TIME;
        return this.findLastModified(lessSource, modified);
    }

    private Time findLastModified(LessSource.URLSource source, Time time) {
        Time max = time;
        try {
            Time lastModified = Connections.getLastModified((URL)source.getInputURL());
            max = (Time)Time.maxNullSafe((LongValue)time, (LongValue)lastModified);
            Collection importedSources = source.getImportedSources();
            if (importedSources != null) {
                for (LessSource importedSource : importedSources) {
                    max = this.findLastModified((LessSource.URLSource)importedSource, max);
                }
            }
        }
        catch (IOException iox) {
            LOG.warn("Cannot read the last modification time of a resource " + source.getInputURL().toExternalForm(), (Throwable)iox);
        }
        return max;
    }

    public void install(Application app) {
        app.setMetaData(KEY, (Object)this);
    }

    public void clearCache() {
        this.urlSourceCache.clear();
        this.contentCache.clear();
    }

    public static LessCacheManager get() {
        if (Application.exists()) {
            return LessCacheManager.get(Application.get());
        }
        throw new IllegalStateException("there is no active application assigned to this thread.");
    }

    private static LessCacheManager get(Application application) {
        return (LessCacheManager)application.getMetaData(KEY);
    }
}

