/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import com.github.sommeri.less4j.Less4jException;
import de.agilecoders.wicket.less.ILessResource;
import de.agilecoders.wicket.less.Less4JCompiler;
import de.agilecoders.wicket.less.LessResource;
import de.agilecoders.wicket.util.Strings2;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.time.Time;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class Less4JCompilerTest {
    private static final Less4JCompiler compiler = new Less4JCompiler();

    @Test
    public void compileWicketLessWithoutErrors() {
        String content = this.compileLessFile("wicket.less");
        MatcherAssert.assertThat((Object)content.length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(100)));
    }

    @Test
    public void compileResponsiveLessWithoutErrors() throws IOException {
        String content = this.compileLessFile("responsive.less");
        MatcherAssert.assertThat((Object)content.length(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(100)));
    }

    @Test
    public void variablesAreReplaced() {
        MatcherAssert.assertThat((Object)this.compile("@var:1; .rule { zoom: @var; }"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)".rule { zoom: 1;}")));
    }

    @Test
    public void starPrefixIsAllowed() {
        MatcherAssert.assertThat((Object)this.compile(".rule { *zoom: 1; }"), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)".rule { *zoom: 1;}")));
    }

    private String compileLessFile(String fileName) {
        String content;
        try {
            content = IOUtils.toString((InputStream)Less4JCompilerTest.class.getResourceAsStream("responsive.less"));
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        return this.compile(content);
    }

    private ILessResource on(final String content) {
        return new ILessResource(){

            public String getPath() {
                return null;
            }

            public Time getLastModificationTime() {
                return Time.now();
            }

            public String asText() {
                return content;
            }

            public boolean exists() {
                return true;
            }

            public InputStream getInputStream() {
                return new ByteArrayInputStream(content.getBytes(Charset.forName("UTF-8")));
            }

            public LessResource getRelative(String subPath) {
                return new LessResource(this.getClass(), subPath);
            }

            public String getName() {
                return "test";
            }

            public File toFile() {
                return new File("");
            }
        };
    }

    private String compile(String content) {
        try {
            return this.removeLineBreaks(IOUtils.toString((InputStream)compiler.compile(this.on(content)).getInputStream(), (String)Charset.forName("UTF-8").toString()));
        }
        catch (Exception e) {
            if (e instanceof Less4jException) {
                return new Less4JCompiler.ErrorLogger("test", (Less4jException)e).toString();
            }
            throw new RuntimeException(e);
        }
    }

    private String removeLineBreaks(String value) {
        return Strings2.nullToEmpty((String)value).replaceAll("\n", "").replaceAll("  ", " ");
    }
}

