/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket;

import de.agilecoders.wicket.less.IBootstrapLessCompilerSettings;
import de.agilecoders.wicket.less.LessResourceStreamLocator;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.core.util.resource.locator.IResourceStreamLocator;
import org.apache.wicket.core.util.resource.locator.caching.CachingResourceStreamLocator;

public final class BootstrapLess {
    private static final MetaDataKey<IBootstrapLessCompilerSettings> BOOTSTRAP_LESS_SETTINGS_METADATA_KEY = new MetaDataKey<IBootstrapLessCompilerSettings>(){};

    private BootstrapLess() {
        throw new UnsupportedOperationException();
    }

    public static void install(Application app, IBootstrapLessCompilerSettings settings) {
        app.setMetaData(BOOTSTRAP_LESS_SETTINGS_METADATA_KEY, (Object)settings);
        if (settings.useLessCompiler()) {
            app.getResourceSettings().setResourceStreamLocator((IResourceStreamLocator)new CachingResourceStreamLocator((IResourceStreamLocator)new LessResourceStreamLocator()));
        }
    }

    public static IBootstrapLessCompilerSettings getSettings(Application app) {
        return (IBootstrapLessCompilerSettings)app.getMetaData(BOOTSTRAP_LESS_SETTINGS_METADATA_KEY);
    }

    public static IBootstrapLessCompilerSettings getSettings() {
        if (Application.exists()) {
            return BootstrapLess.getSettings(Application.get());
        }
        throw new IllegalStateException("there is no active application assigned to this thread.");
    }
}

