/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import com.github.sommeri.less4j.Less4jException;
import com.github.sommeri.less4j.LessCompiler;
import com.github.sommeri.less4j.core.ThreadUnsafeLessCompiler;
import de.agilecoders.wicket.less.AbstractCompiledResource;
import de.agilecoders.wicket.less.AbstractLessCompiler;
import de.agilecoders.wicket.less.ICombinedLessResource;
import de.agilecoders.wicket.less.ICompiledResource;
import de.agilecoders.wicket.less.ILessResource;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.io.IClusterable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Less4JCompiler
extends AbstractLessCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(Less4JCompiler.class);

    @Override
    public ICompiledResource compile(ILessResource lessResource) {
        ICombinedLessResource combinedLessResource = this.collect(lessResource);
        return new AbstractCompiledResource(combinedLessResource){

            @Override
            protected byte[] compile(ICombinedLessResource lessFile) {
                long start = System.currentTimeMillis();
                ThreadUnsafeLessCompiler compiler = new ThreadUnsafeLessCompiler();
                try {
                    byte[] byArray = compiler.compile(lessFile.asText()).getCss().getBytes(Less4JCompiler.this.getCharset());
                    return byArray;
                }
                catch (Less4jException e) {
                    LOG.error("can't compile {}: {}", (Object)lessFile.getName(), (Object)new ErrorLogger(lessFile.getName(), e));
                    throw new WicketRuntimeException("can't compile " + lessFile.getName(), (Throwable)e);
                }
                finally {
                    LOG.debug("duration of collect imports for {}: {} ms", (Object)lessFile.getName(), (Object)(System.currentTimeMillis() - start));
                }
            }
        };
    }

    protected static final class ErrorLogger
    implements IClusterable {
        private final String name;
        private final Less4jException e;

        ErrorLogger(String name, Less4jException e) {
            this.name = name;
            this.e = e;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("less4j errors while generating '" + this.name + "':\n");
            for (LessCompiler.Problem error : this.e.getErrors()) {
                builder.append("  > [").append(error.getType()).append("] ").append(error.getMessage()).append(" in line ").append(error.getLine()).append(":").append(error.getCharacter()).append("\n");
            }
            return builder.toString();
        }
    }
}

