/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import de.agilecoders.wicket.less.ICombinedLessResource;
import de.agilecoders.wicket.less.ILessResource;
import de.agilecoders.wicket.less.LessResource;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.time.AbstractTimeValue;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessContentCollector {
    private static final Logger LOG = LoggerFactory.getLogger(LessContentCollector.class);
    private static final Pattern IMPORT_PATTERN = Pattern.compile(".*@import\\s*\"(.*?)\".*");

    public ICombinedLessResource collect(ILessResource lessResource) {
        return this.newCombinedLessFile(lessResource);
    }

    public Future<ICombinedLessResource> collectAsync(final ILessResource lessResource) {
        return new FutureTask<ICombinedLessResource>(new Callable<ICombinedLessResource>(){

            @Override
            public ICombinedLessResource call() throws Exception {
                return LessContentCollector.this.collect(lessResource);
            }
        });
    }

    private ICombinedLessResource newCombinedLessFile(ILessResource lessResource) {
        CombinedLessResource combinedLessResource = new CombinedLessResource(lessResource);
        this.addAllImports(combinedLessResource, lessResource);
        return combinedLessResource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addAllImports(CombinedLessResource lessResource, ILessResource resource) {
        BufferedReader r = null;
        try {
            String line;
            r = new BufferedReader(new InputStreamReader(resource.getInputStream()));
            while ((line = r.readLine()) != null) {
                Matcher m = IMPORT_PATTERN.matcher(line);
                while (m.find()) {
                    LessResource file = resource.getRelative(m.group(1));
                    if (!file.exists() && !m.group(1).endsWith(".less")) {
                        file = resource.getRelative(m.group(1) + ".less");
                    }
                    this.addAllImports(lessResource, file);
                    lessResource.addImport(file);
                }
            }
            lessResource.addImport(resource);
        }
        catch (IOException e) {
            try {
                LOG.error("{}", (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(r);
                throw throwable;
            }
            IOUtils.closeQuietly((Closeable)r);
        }
        IOUtils.closeQuietly((Closeable)r);
    }

    private static final class CombinedLessResource
    implements ICombinedLessResource {
        private final List<String> cache = new ArrayList<String>();
        private final ILessResource resource;
        private final StringBuilder builder;
        private Time lastModified;
        private final String name;

        private CombinedLessResource(ILessResource resource) {
            this.name = resource.getName();
            this.resource = resource;
            this.builder = new StringBuilder();
            this.lastModified = Time.START_OF_UNIX_TIME;
        }

        private void addImport(ILessResource resource) {
            if (!this.cache.contains(resource.getPath())) {
                this.builder.append(IMPORT_PATTERN.matcher(resource.asText()).replaceAll(""));
                this.updateLastModified(resource);
                this.cache.add(resource.getPath());
            }
        }

        private void updateLastModified(ILessResource resource) {
            if (this.lastModified.before((AbstractTimeValue)resource.getLastModificationTime())) {
                this.lastModified = resource.getLastModificationTime();
            }
        }

        @Override
        public final Time getModificationTime() {
            return this.lastModified;
        }

        @Override
        public final String asText() {
            if (this.resource != null) {
                this.addImport(this.resource);
            }
            return this.builder.toString();
        }

        @Override
        public final String getName() {
            return this.name;
        }
    }
}

