/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import com.asual.lesscss.LessEngine;
import com.asual.lesscss.LessException;
import com.asual.lesscss.LessOptions;
import de.agilecoders.wicket.less.AbstractCompiledResource;
import de.agilecoders.wicket.less.AbstractLessCompiler;
import de.agilecoders.wicket.less.ICombinedLessResource;
import de.agilecoders.wicket.less.ICompiledResource;
import de.agilecoders.wicket.less.ILessResource;
import de.agilecoders.wicket.util.Generics2;
import java.io.FileNotFoundException;
import java.util.List;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.lang.Exceptions;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessJsLessCompiler
extends AbstractLessCompiler {
    private static final Logger LOG = LoggerFactory.getLogger(LessJsLessCompiler.class);

    private static LessEngine getLessEngine() {
        return LessEngineHolder.instance;
    }

    @Override
    public ICompiledResource compile(ILessResource lessResource) {
        return this.compile(this.collect(lessResource));
    }

    protected ICompiledResource compile(ICombinedLessResource lessFile) {
        return new AbstractCompiledResource(lessFile){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected byte[] compile(ICombinedLessResource lessFile) {
                long start = System.currentTimeMillis();
                try {
                    byte[] byArray = LessJsLessCompiler.getLessEngine().compile(lessFile.asText()).getBytes(LessJsLessCompiler.this.getCharset());
                    return byArray;
                }
                catch (LessException e) {
                    byte[] byArray = LessJsLessCompiler.this.handleException(e);
                    return byArray;
                }
                finally {
                    LOG.debug("duration of less compiler for {}: {} ms", (Object)lessFile.getName(), (Object)(System.currentTimeMillis() - start));
                }
            }
        };
    }

    private byte[] handleException(LessException e) {
        FileNotFoundException fileNotFoundException;
        String filename = e.getFilename();
        List extractList = e.getExtract();
        String extract = null;
        if (extractList != null) {
            extract = Generics2.join((Iterable)extractList, (char)',');
        }
        if (Strings.isEmpty(extract) && (fileNotFoundException = (FileNotFoundException)Exceptions.findCause((Throwable)e, FileNotFoundException.class)) != null) {
            extract = fileNotFoundException.getMessage();
        }
        throw new WicketRuntimeException("can't parse " + filename + "; error in line " + e.getLine() + " on column " + e.getColumn() + "; " + e.getType() + ": " + extract);
    }

    private static class LessEngineHolder {
        private static final LessEngine instance = new LessEngine(new LessOptions());

        private LessEngineHolder() {
        }
    }
}

