/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import de.agilecoders.wicket.BootstrapLess;
import de.agilecoders.wicket.less.ILessResource;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.io.Connections;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.time.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessResource
implements ILessResource {
    private static final Logger LOG = LoggerFactory.getLogger(LessResource.class);
    private final Class<?> scope;
    private final String path;
    private final Time lastModified;

    public LessResource(Class<?> scope, String path) {
        this.scope = scope;
        this.path = path;
        try {
            this.lastModified = Connections.getLastModified((URL)Thread.currentThread().getContextClassLoader().getResource(path));
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public Time getLastModificationTime() {
        return this.lastModified;
    }

    @Override
    public String asText() {
        InputStream stream = null;
        try {
            stream = this.getInputStream();
            String string = IOUtils.toString((InputStream)stream, (String)BootstrapLess.getSettings().getCharset().name());
            return string;
        }
        catch (IOException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    @Override
    public boolean exists() {
        return this.scope.getResource(this.path) != null;
    }

    @Override
    public InputStream getInputStream() {
        return Thread.currentThread().getContextClassLoader().getResourceAsStream(this.path);
    }

    @Override
    public LessResource getRelative(String subPath) {
        String parentPath = this.findParentName(this.path, subPath);
        try {
            return new LessResource(this.scope, parentPath);
        }
        catch (RuntimeException e) {
            LOG.error("can't load: {}; {}", (Object)parentPath, (Object)e.getMessage());
            throw new WicketRuntimeException("error loading: " + parentPath, (Throwable)e);
        }
    }

    private String findParentName(String base, String path) {
        int index = Math.max(base.lastIndexOf(47), 0);
        return this.normalize(base.substring(0, index + 1) + path);
    }

    private String normalize(String path) {
        while (path.contains("../")) {
            int index = path.indexOf("../");
            String start = this.findParentName(path.substring(0, index - 1), "");
            String end = path.substring(index + 3);
            path = start + end;
        }
        return path;
    }

    @Override
    public String getName() {
        int index = this.path.lastIndexOf(47);
        return this.path.substring(index + 1);
    }

    @Override
    public File toFile() {
        return new File(this.scope.getResource(this.getPath()).toString());
    }
}

