/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import de.agilecoders.wicket.BootstrapLess;
import de.agilecoders.wicket.less.IBootstrapLessCompiler;
import de.agilecoders.wicket.less.ICompiledResource;
import de.agilecoders.wicket.less.LessResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.core.util.resource.locator.ResourceStreamLocator;
import org.apache.wicket.request.resource.CssResourceReference;
import org.apache.wicket.util.file.IResourceFinder;
import org.apache.wicket.util.io.IClusterable;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.resource.AbstractResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamNotFoundException;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LessResourceStreamLocator
extends ResourceStreamLocator {
    private static final Logger LOG = LoggerFactory.getLogger(LessResourceStreamLocator.class);
    private final ThreadLocal<Set<String>> THREAD_CACHE = new ThreadLocal<Set<String>>(){

        @Override
        protected Set<String> initialValue() {
            return new HashSet<String>();
        }
    };
    private final ConcurrentMap<String, CacheValue> CACHE = new ConcurrentHashMap<String, CacheValue>();

    public LessResourceStreamLocator() {
        this(null);
    }

    public LessResourceStreamLocator(List<IResourceFinder> finders) {
        super(finders);
    }

    public IResourceStream locate(Class<?> clazz, String path) {
        return super.locate(clazz, path);
    }

    public IResourceStream locate(Class<?> clazz, String path, String style, String variation, Locale locale, String extension, boolean strict) {
        if (LessResourceStreamLocator.isActive(clazz, variation)) {
            return this.fromCacheOrLoadAndCompile(clazz, path);
        }
        return super.locate(clazz, path, style, variation, locale, extension, strict);
    }

    private static String createKey(Class<?> clazz, String path) {
        return clazz.getName() + "##" + path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IResourceStream fromCacheOrLoadAndCompile(Class<?> clazz, String path) {
        LessResourceStream lessResourceStream;
        String key;
        long startCache = System.currentTimeMillis();
        String string = key = LessResourceStreamLocator.createKey(clazz, path);
        synchronized (string) {
            CacheValue cacheValue = (CacheValue)this.CACHE.get(key);
            if (this.THREAD_CACHE.get().contains(key) && cacheValue != null) {
                LOG.debug("L1 cache hit: loading of {} from L1 cache took {} ms", (Object)path, (Object)(System.currentTimeMillis() - startCache));
                return cacheValue.original;
            }
            this.THREAD_CACHE.get().add(key);
            lessResourceStream = this.loadStream(clazz, path);
            if (cacheValue != null && cacheValue.isUpToDate(lessResourceStream.lastModifiedTime())) {
                LOG.debug("L2 cache hit: loading of {} from L2 cache took {} ms", (Object)path, (Object)(System.currentTimeMillis() - startCache));
                return cacheValue.original;
            }
            this.CACHE.put(key, new CacheValue((IResourceStream)lessResourceStream));
        }
        LOG.debug("cache miss: loading of {} took {} ms", (Object)path, (Object)(System.currentTimeMillis() - startCache));
        return lessResourceStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LessResourceStream loadStream(Class<?> clazz, String path) {
        long start = System.currentTimeMillis();
        try {
            LessResourceStream lessResourceStream = new LessResourceStream(LessResourceStreamLocator.compile(clazz, path.replace(".min.css", ".less").replace(".css", ".less")));
            return lessResourceStream;
        }
        finally {
            LOG.debug("loading stream of {} took {} ms", (Object)path, (Object)(System.currentTimeMillis() - start));
        }
    }

    private static boolean useLessCompiler() {
        return BootstrapLess.getSettings().useLessCompiler();
    }

    private static boolean isActive(Class clazz, String variation) {
        return LessResourceStreamLocator.useLessCompiler() && CssResourceReference.class.isAssignableFrom(clazz) && "less".equals(variation);
    }

    private static ICompiledResource compile(Class<?> clazz, String path) {
        return LessResourceStreamLocator.getCompiler().compile(new LessResource(clazz, path));
    }

    private static IBootstrapLessCompiler getCompiler() {
        if (Application.exists()) {
            return BootstrapLess.getSettings().getLessCompiler();
        }
        throw new IllegalStateException("there is no application assigned to current thread.");
    }

    public static final class LessResourceStream
    extends AbstractResourceStream {
        private final ICompiledResource compiledResource;

        public LessResourceStream(ICompiledResource compiledResource) {
            this.compiledResource = compiledResource;
        }

        public String getContentType() {
            return "text/css";
        }

        public Bytes length() {
            return this.compiledResource.length();
        }

        public InputStream getInputStream() throws ResourceStreamNotFoundException {
            return this.compiledResource.getInputStream();
        }

        public void close() throws IOException {
            this.compiledResource.close();
        }

        public Time lastModifiedTime() {
            return this.compiledResource.getModificationTime();
        }

        public String getVariation() {
            return "less";
        }
    }

    private static final class CacheValue
    implements IClusterable {
        private final IResourceStream original;
        private final Time modificationTime;

        private CacheValue(IResourceStream original) {
            this.original = original;
            this.modificationTime = original.lastModifiedTime();
        }

        public boolean isUpToDate(Time time) {
            return time == null || time.lessThanOrEqual((LongValue)this.modificationTime);
        }
    }
}

