/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import de.agilecoders.wicket.less.AbstractLessCompiler;
import de.agilecoders.wicket.less.ICompiledResource;
import de.agilecoders.wicket.less.ILessResource;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.wicket.util.lang.Bytes;
import org.apache.wicket.util.time.Time;

public class NoOpLessCompiler
extends AbstractLessCompiler {
    @Override
    public ICompiledResource compile(ILessResource lessResource) {
        return new CompiledResource(lessResource, this.getCharset());
    }

    public static final class CompiledResource
    implements ICompiledResource {
        private final byte[] bytes;
        private final Time modificationTime;

        public CompiledResource(ILessResource lessResource, Charset charset) {
            this.bytes = lessResource.asText().getBytes(charset);
            this.modificationTime = lessResource.getLastModificationTime();
        }

        @Override
        public Time getModificationTime() {
            return this.modificationTime;
        }

        @Override
        public InputStream getInputStream() {
            return new ByteArrayInputStream(this.bytes);
        }

        @Override
        public Bytes length() {
            return Bytes.bytes((long)this.bytes.length);
        }

        @Override
        public void close() throws IOException {
        }
    }
}

