/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.less;

import de.agilecoders.wicket.less.LessCacheManager;
import de.agilecoders.wicket.less.LessCompilerConfigurationFactory;
import de.agilecoders.wicket.less.LessResourceReferenceFactory;
import org.apache.wicket.Application;
import org.apache.wicket.markup.html.IPackageResourceGuard;
import org.apache.wicket.markup.html.SecurePackageResourceGuard;
import org.apache.wicket.request.resource.IResourceReferenceFactory;
import org.apache.wicket.request.resource.ResourceReferenceRegistry;

public final class BootstrapLess {
    private BootstrapLess() {
        throw new UnsupportedOperationException();
    }

    public static void install(Application app, LessCompilerConfigurationFactory configFactory) {
        LessCacheManager cacheManager = new LessCacheManager(configFactory);
        cacheManager.install(app);
        IPackageResourceGuard resourceGuard = app.getResourceSettings().getPackageResourceGuard();
        if (resourceGuard instanceof SecurePackageResourceGuard) {
            SecurePackageResourceGuard securePackageResourceGuard = (SecurePackageResourceGuard)resourceGuard;
            securePackageResourceGuard.addPattern("+*.less");
        }
        ResourceReferenceRegistry resourceReferenceRegistry = app.getResourceReferenceRegistry();
        IResourceReferenceFactory delegate = resourceReferenceRegistry.getResourceReferenceFactory();
        resourceReferenceRegistry.setResourceReferenceFactory((IResourceReferenceFactory)new LessResourceReferenceFactory(delegate));
    }

    public static void install(Application app) {
        BootstrapLess.install(app, null);
    }
}

