/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.sass;

import de.agilecoders.wicket.sass.SassCompilerOptionsFactory;
import de.agilecoders.wicket.sass.SassSource;
import de.agilecoders.wicket.sass.SimpleSassCompilerOptionsFactory;
import de.agilecoders.wicket.sass.TrackingImporter;
import de.agilecoders.wicket.sass.UrlImporter;
import io.bit3.jsass.CompilationException;
import io.bit3.jsass.Compiler;
import io.bit3.jsass.Options;
import io.bit3.jsass.Output;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.wicket.Application;
import org.apache.wicket.MetaDataKey;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.util.io.Connections;
import org.apache.wicket.util.time.Time;
import org.apache.wicket.util.value.LongValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SassCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(SassCacheManager.class);
    private static final MetaDataKey<SassCacheManager> KEY = new MetaDataKey<SassCacheManager>(){
        private static final long serialVersionUID = 1L;
    };
    private final ConcurrentMap<URL, SassSource> urlSourceCache = new ConcurrentHashMap<URL, SassSource>();
    private final ConcurrentMap<SassSource, ConcurrentMap<Time, String>> contentCache = new ConcurrentHashMap<SassSource, ConcurrentMap<Time, String>>();
    private final SassCompilerOptionsFactory optionsFactory;

    public SassCacheManager(SassCompilerOptionsFactory optionsFactory) {
        this.optionsFactory = optionsFactory != null ? optionsFactory : new SimpleSassCompilerOptionsFactory();
    }

    public SassCacheManager() {
        this(null);
    }

    public SassSource getSassContext(URL sassUrl, String scopeClass) {
        SassSource sassSource = new SassSource(sassUrl.toExternalForm(), scopeClass);
        SassSource oldValue = this.urlSourceCache.putIfAbsent(sassUrl, sassSource);
        if (oldValue != null) {
            sassSource = oldValue;
        }
        return sassSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCss(SassSource sassSource) {
        Time lastModifiedTime;
        String cssContent;
        ConcurrentMap old;
        ConcurrentMap<Time, String> timeToContentMap = (ConcurrentHashMap)this.contentCache.get(sassSource);
        if (timeToContentMap == null && (old = (ConcurrentMap)this.contentCache.putIfAbsent(sassSource, timeToContentMap = new ConcurrentHashMap())) != null) {
            timeToContentMap = old;
        }
        if ((cssContent = (String)timeToContentMap.get(lastModifiedTime = this.getLastModifiedTime(sassSource))) == null) {
            SassSource sassSource2 = sassSource;
            synchronized (sassSource2) {
                lastModifiedTime = this.getLastModifiedTime(sassSource);
                cssContent = (String)timeToContentMap.get(lastModifiedTime);
                if (cssContent == null) {
                    timeToContentMap.clear();
                    Compiler compiler = new Compiler();
                    Options options = this.optionsFactory.newOptions();
                    TrackingImporter trackingImporter = new TrackingImporter(sassSource.getScopeClass(), new UrlImporter(sassSource.getScopeClass()));
                    options.getImporters().add(trackingImporter);
                    options.setOmitSourceMapUrl(false);
                    try {
                        Output result = compiler.compileFile(sassSource.getURL().toURI(), null, options);
                        sassSource.addImportedSources(trackingImporter.getImportedSources());
                        cssContent = result.getCss();
                        lastModifiedTime = this.getLastModifiedTime(sassSource);
                        timeToContentMap.put(lastModifiedTime, cssContent);
                    }
                    catch (URISyntaxException ex) {
                        throw new WicketRuntimeException("Cannot create URI for resource.", (Throwable)ex);
                    }
                    catch (CompilationException x) {
                        throw new WicketRuntimeException("An error occurred while compiling Less resource " + sassSource.getURL().toExternalForm() + ". " + x.getErrorJson(), (Throwable)x);
                    }
                }
            }
        }
        return cssContent;
    }

    public Time getLastModifiedTime(SassSource sassSource) {
        Time modified = Time.START_OF_UNIX_TIME;
        return this.findLastModified(sassSource, modified);
    }

    private Time findLastModified(SassSource source, Time time) {
        Time max = time;
        try {
            Time lastModified = Connections.getLastModified((URL)source.getURL());
            max = (Time)Time.maxNullSafe((LongValue)time, (LongValue)lastModified);
            Collection<SassSource> importedSources = source.getImportedSources();
            if (importedSources != null) {
                SassSource[] importedSourcesArray = importedSources.toArray(new SassSource[0]);
                int size = importedSourcesArray.length;
                for (int i = 0; i < size; ++i) {
                    max = this.findLastModified(importedSourcesArray[i], max);
                }
            }
        }
        catch (IOException iox) {
            LOG.warn("Cannot read the last modification time of a resource " + source.getURL().toExternalForm(), (Throwable)iox);
        }
        return max;
    }

    public void install(Application app) {
        app.setMetaData(KEY, (Object)this);
    }

    public void clearCache() {
        this.urlSourceCache.clear();
        this.contentCache.clear();
    }

    public static SassCacheManager get() {
        if (Application.exists()) {
            return SassCacheManager.get(Application.get());
        }
        throw new IllegalStateException("there is no active application assigned to this thread.");
    }

    private static SassCacheManager get(Application application) {
        return (SassCacheManager)application.getMetaData(KEY);
    }
}

