/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.sass;

import de.agilecoders.wicket.sass.SassCacheManager;
import de.agilecoders.wicket.sass.SassSource;
import java.net.URL;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.resource.UrlResourceStream;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.resource.AbstractStringResourceStream;
import org.apache.wicket.util.resource.IResourceStream;
import org.apache.wicket.util.resource.ResourceStreamWrapper;
import org.apache.wicket.util.time.Time;

public class SassResourceStream
extends AbstractStringResourceStream {
    private final SassSource sassSource;

    public SassResourceStream(IResourceStream sassStream, String scopeClass) {
        Args.notNull((Object)sassStream, (String)"sassStream");
        while (sassStream instanceof ResourceStreamWrapper) {
            ResourceStreamWrapper wrapper = (ResourceStreamWrapper)sassStream;
            try {
                sassStream = wrapper.getDelegate();
            }
            catch (Exception x) {
                throw new WicketRuntimeException((Throwable)x);
            }
        }
        if (!(sassStream instanceof UrlResourceStream)) {
            throw new IllegalArgumentException(String.format("%s can work only with %s", SassResourceStream.class.getSimpleName(), UrlResourceStream.class.getName()));
        }
        URL sassUrl = ((UrlResourceStream)sassStream).getURL();
        SassCacheManager cacheManager = SassCacheManager.get();
        this.sassSource = cacheManager.getSassContext(sassUrl, scopeClass);
    }

    protected String getString() {
        SassCacheManager cacheManager = SassCacheManager.get();
        return cacheManager.getCss(this.sassSource);
    }

    public Time lastModifiedTime() {
        SassCacheManager cacheManager = SassCacheManager.get();
        return cacheManager.getLastModifiedTime(this.sassSource);
    }

    public String getContentType() {
        return "text/css";
    }
}

