/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.sass;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;

class SassSource {
    private final String filepath;
    private final String scopeClass;
    private final Collection<SassSource> importedSources;

    SassSource(String filepath, String scopeClass) {
        this.filepath = filepath;
        this.scopeClass = scopeClass;
        this.importedSources = new ArrayList<SassSource>();
    }

    public URL getURL() {
        try {
            return new URL(this.filepath);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Cannot create a URL to a resource", e);
        }
    }

    public String getScopeClass() {
        return this.scopeClass;
    }

    public Collection<SassSource> getImportedSources() {
        return this.importedSources;
    }

    public void addImportedSources(Collection<SassSource> sources) {
        this.importedSources.addAll(sources);
    }
}

