/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.sass;

import de.agilecoders.wicket.sass.SassSource;
import io.bit3.jsass.importer.Import;
import io.bit3.jsass.importer.Importer;
import java.util.ArrayList;
import java.util.Collection;

class TrackingImporter
implements Importer {
    private final Collection<SassSource> importedSources;
    private final String scopeClass;
    private final Importer delegate;

    public TrackingImporter(String scopeClass, Importer delegate) {
        this.scopeClass = scopeClass;
        this.delegate = delegate;
        this.importedSources = new ArrayList<SassSource>();
    }

    public Collection<SassSource> getImportedSources() {
        return this.importedSources;
    }

    public Collection<Import> apply(String url, Import previous) {
        this.importedSources.clear();
        Collection imports = this.delegate.apply(url, previous);
        if (imports != null && !imports.isEmpty()) {
            imports.stream().findFirst().map(Import::getImportUri).ifPresent(importUri -> this.importedSources.add(new SassSource(importUri.toString(), this.scopeClass)));
        }
        return imports;
    }
}

