/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.sass;

import de.agilecoders.wicket.sass.SassCacheManager;
import de.agilecoders.wicket.sass.SassSource;
import de.agilecoders.wicket.webjars.WicketWebjars;
import de.agilecoders.wicket.webjars.util.WebJarAssetLocator;
import io.bit3.jsass.importer.Import;
import io.bit3.jsass.importer.Importer;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Stream;
import javax.servlet.ServletContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.wicket.Application;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.core.util.lang.WicketObjects;
import org.apache.wicket.protocol.http.WebApplication;
import org.apache.wicket.util.io.IOUtils;
import org.apache.wicket.util.string.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class UrlImporter
implements Importer {
    private static final Logger LOG = LoggerFactory.getLogger(SassSource.class);
    private static final String SCSS_EXT = ".scss";
    private static final String SASS_EXT = ".sass";
    public static final String CLASSPATH_SCHEME = "classpath!";
    public static final String PACKAGE_SCHEME = "package!";
    public static final String WEBJARS_SCHEME = "webjars!";
    public static final String WEB_CONTEXT_SCHEME = "webcontext!";
    public static final String JAR_SCHEME = "jar!";
    private final String scopeClass;

    public UrlImporter(String scopeClass) {
        this.scopeClass = scopeClass;
    }

    public Collection<Import> apply(String url, Import previous) {
        return Stream.concat(this.withExtension(url), this.cssUri(url)).map(candidate -> this.tryResolveUrl(previous.getAbsoluteUri(), (String)candidate)).filter(Optional::isPresent).map(Optional::get).findFirst().map(Collections::singletonList).orElse(null);
    }

    private Optional<Import> tryResolveUrl(URI base, String url) {
        Optional<Import> newImport = StringUtils.startsWith((CharSequence)url, (CharSequence)WEBJARS_SCHEME) ? this.resolveWebJarsDependency(url) : (StringUtils.startsWith((CharSequence)url, (CharSequence)CLASSPATH_SCHEME) ? this.resolveClasspathDependency(url) : (StringUtils.startsWith((CharSequence)url, (CharSequence)WEB_CONTEXT_SCHEME) ? this.resolveWebContextDependency(url) : (this.scopeClass != null && StringUtils.startsWith((CharSequence)url, (CharSequence)PACKAGE_SCHEME) ? this.resolvePackageDependency(url) : this.resolveLocalDependency(base, url))));
        return newImport;
    }

    private Stream<String> withExtension(String url) {
        String withScssExt = url + SCSS_EXT;
        String withSassExt = url + SASS_EXT;
        return url.endsWith(SCSS_EXT) || url.endsWith(SASS_EXT) ? Stream.of(url, this.addUnderscore(url)) : Stream.of(withScssExt, this.addUnderscore(withScssExt), withSassExt, this.addUnderscore(withSassExt));
    }

    private Stream<String> cssUri(String url) {
        return Stream.of(url).filter(u -> u.endsWith(".css"));
    }

    private String addUnderscore(String url) {
        int lastSlash = url.lastIndexOf("/");
        return new StringBuilder(url).insert(lastSlash + 1, "_").toString();
    }

    private Optional<Import> resolveWebJarsDependency(String url) {
        LOG.debug("Going to resolve an import from WebJars: {}", (Object)url);
        try {
            String file = Holder.locator.getFullPath(url.replaceFirst(WEBJARS_SCHEME, "/webjars/"));
            URL importUrl = Thread.currentThread().getContextClassLoader().getResource(file);
            return Optional.ofNullable(importUrl).map(this::buildImport);
        }
        catch (WebJarAssetLocator.ResourceException e) {
            LOG.debug("Webjar resource [" + url + "] wasn't found");
        }
        catch (RuntimeException e) {
            throw new WicketRuntimeException((Throwable)e);
        }
        return Optional.empty();
    }

    private Optional<Import> resolveClasspathDependency(String url) {
        LOG.debug("Going to resolve an import from the classpath: {}", (Object)url);
        String resourceName = url.substring(CLASSPATH_SCHEME.length() + 1);
        if (resourceName.indexOf(0) != 47) {
            resourceName = '/' + resourceName;
        }
        URL importUrl = SassCacheManager.class.getResource(resourceName);
        return Optional.ofNullable(importUrl).map(this::buildImport);
    }

    private Optional<Import> resolveWebContextDependency(String url) {
        LOG.debug("Going to resolve an import from the web context: {}", (Object)url);
        String resourceName = url.substring(WEB_CONTEXT_SCHEME.length());
        if (resourceName.indexOf(0) == 47) {
            resourceName = resourceName.substring(1);
        }
        ServletContext context = ((WebApplication)Application.get()).getServletContext();
        try {
            return Optional.of(this.buildImport(context.getResource(resourceName)));
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Cannot create a URL to a resource in the web context", ex);
        }
    }

    private Optional<Import> resolvePackageDependency(String url) {
        String resourceName;
        if (Strings.isEmpty((CharSequence)this.scopeClass)) {
            throw new IllegalStateException("Cannot resolve dependency '" + url + "' without a scope class!");
        }
        LOG.debug("Going to resolve an import from the package: {}", (Object)url);
        String string = resourceName = url.startsWith(PACKAGE_SCHEME) ? url.substring(PACKAGE_SCHEME.length()) : url;
        if (resourceName.indexOf(0) == 47) {
            resourceName = resourceName.substring(1);
        }
        Class scope = WicketObjects.resolveClass((String)this.scopeClass);
        URL importUrl = scope.getResource(resourceName);
        return Optional.ofNullable(importUrl).map(this::buildImport);
    }

    private Optional<Import> resolveLocalDependency(URI base, String url) {
        LOG.debug("Going to resolve an import from local dependency: {}", (Object)url);
        String importUrl = this.getAbsolutePath(base, url);
        Optional<Import> localImport = this.resolveLocalFileDependency(importUrl);
        return localImport.isPresent() ? localImport : this.resolveJarDependency(importUrl);
    }

    private Optional<Import> resolveJarDependency(String url) {
        LOG.debug("Going to resolve an import from jar file: {}", (Object)url);
        int jarSchemeIndex = url.indexOf(JAR_SCHEME);
        if (jarSchemeIndex == -1) {
            return Optional.empty();
        }
        int resourceNameIndex = jarSchemeIndex + JAR_SCHEME.length();
        String resourceName = url.substring(resourceNameIndex);
        if (!resourceName.startsWith("/")) {
            resourceName = "/" + resourceName;
        }
        URL importUrl = SassCacheManager.class.getResource(resourceName);
        return Optional.ofNullable(importUrl).map(this::buildImport);
    }

    private Optional<Import> resolveLocalFileDependency(String url) {
        LOG.debug("Going to resolve an import from local file: {}", (Object)url);
        File file = new File(url);
        if (file.exists()) {
            try {
                return Optional.of(this.buildImport(file.toURI().toURL()));
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(String.format("Cannot resolve local dependency at path '%s'", url));
            }
        }
        return Optional.empty();
    }

    private String getAbsolutePath(URI base, String url) {
        String basePath = base.toString();
        Path parentBasePath = Paths.get(basePath, new String[0]).getParent();
        return parentBasePath.resolve(url).toString();
    }

    private Import buildImport(URL importUri) {
        try {
            String contents = this.read(importUri);
            return new Import(importUri.toURI(), importUri.toURI(), contents);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String read(URL url) {
        try {
            return IOUtils.toString((InputStream)url.openStream(), (String)StandardCharsets.UTF_8.name());
        }
        catch (IOException ex) {
            throw new WicketRuntimeException((Throwable)ex);
        }
    }

    private static final class Holder {
        private static final WebJarAssetLocator locator = new WebJarAssetLocator(WicketWebjars.settings());

        private Holder() {
        }
    }
}

