/*
 * Decompiled with CFR 0.152.
 */
package de.agilecoders.wicket.themes.markup.html.bootswatch;

import de.agilecoders.wicket.core.Bootstrap;
import de.agilecoders.wicket.core.settings.IBootstrapSettings;
import de.agilecoders.wicket.core.settings.ITheme;
import de.agilecoders.wicket.themes.markup.html.bootswatch.BootswatchCssReference;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.Application;
import org.apache.wicket.markup.head.CssHeaderItem;
import org.apache.wicket.markup.head.HeaderItem;
import org.apache.wicket.markup.head.IHeaderResponse;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.resource.ResourceReference;
import org.apache.wicket.request.resource.UrlResourceReference;

public enum BootswatchTheme implements ITheme
{
    Cerulean,
    Cosmo,
    Cyborg,
    Darkly,
    Flatly,
    Journal,
    Litera,
    Lumen,
    Lux,
    Materia,
    Minty,
    Morth,
    Pulse,
    Quartz,
    Sandstone,
    Simplex,
    Sketchy,
    Slate,
    Solar,
    Spacelab,
    Superhero,
    United,
    Vapor,
    Yeti,
    Zephyr;

    private static final String CDN_PATTERN = "////cdn.jsdelivr.net/npm/bootswatch@%s/dist/%s/bootstrap.min.css";
    private String cdnUrl;
    private final ResourceReference reference = new BootswatchCssReference(this.name().toLowerCase());

    public Iterable<String> getCdnUrls() {
        return Collections.singletonList(this.cdnUrl);
    }

    public List<HeaderItem> getDependencies() {
        return Collections.singletonList(CssHeaderItem.forReference((ResourceReference)this.reference).setId("wb-theme"));
    }

    public void renderHead(IHeaderResponse response) {
        if (this.useCdnResources()) {
            if (this.cdnUrl == null) {
                this.cdnUrl = String.format(CDN_PATTERN, this.getBootstrapVersion(), this.name().toLowerCase());
            }
            response.render((HeaderItem)CssHeaderItem.forReference((ResourceReference)new UrlResourceReference(Url.parse((CharSequence)this.cdnUrl))));
        } else {
            for (HeaderItem headerItem : this.getDependencies()) {
                response.render(headerItem);
            }
        }
    }

    private boolean useCdnResources() {
        IBootstrapSettings settings;
        boolean result = false;
        if (Application.exists() && (settings = Bootstrap.getSettings()) != null) {
            result = settings.useCdnResources();
        }
        return result;
    }

    private String getBootstrapVersion() {
        IBootstrapSettings settings;
        String version = "5.2.3";
        if (Application.exists() && (settings = Bootstrap.getSettings()) != null) {
            version = settings.getVersion();
        }
        return version;
    }
}

