/*
 * Decompiled with CFR 0.152.
 */
package de.almostintelligent.jaste;

import de.almostintelligent.jaste.Page;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PageFactory {
    private static Logger logger = LoggerFactory.getLogger(PageFactory.class);

    public static Page createPage(String p) {
        StringReader in = new StringReader(p);
        return PageFactory.parsePage(in);
    }

    public static Page createPage(File f) {
        try {
            FileReader in = new FileReader(f);
            return PageFactory.parsePage(in);
        }
        catch (FileNotFoundException e) {
            logger.error(e.getMessage());
            return null;
        }
    }

    private static Page parsePage(Reader in) {
        try {
            int c;
            while ((c = in.read()) != -1) {
                System.out.print((char)c);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage());
        }
        return null;
    }
}

