/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key;

import de.alpharogroup.crypto.hex.HexExtensions;
import de.alpharogroup.crypto.key.writer.PublicKeyWriter;
import de.alpharogroup.string.StringExtensions;
import java.io.File;
import java.io.IOException;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.codec.binary.Base64;

public final class PublicKeyExtensions {
    public static int getKeyLength(PublicKey publicKey) {
        int length = -1;
        if (publicKey == null) {
            return length;
        }
        if (publicKey instanceof RSAPublicKey) {
            length = ((RSAPublicKey)publicKey).getModulus().bitLength();
        }
        if (publicKey instanceof DSAPublicKey) {
            length = ((DSAPublicKey)publicKey).getParams().getP().bitLength();
        }
        if (publicKey instanceof ECPublicKey) {
            length = ((ECPublicKey)publicKey).getParams().getCurve().getField().getFieldSize();
        }
        return length;
    }

    public static String toHexString(PublicKey publicKey) {
        return PublicKeyExtensions.toHexString(publicKey, true);
    }

    public static String toBase64(PublicKey publicKey) {
        byte[] encoded = publicKey.getEncoded();
        return Base64.encodeBase64String((byte[])encoded);
    }

    public static String toPemFormat(PublicKey publicKey) {
        String publicKeyAsBase64String = PublicKeyExtensions.toBase64(publicKey);
        List parts = StringExtensions.splitByFixedLength((String)publicKeyAsBase64String, (int)64);
        StringBuilder sb = new StringBuilder();
        sb.append("-----BEGIN PUBLIC KEY-----\n");
        for (String part : parts) {
            sb.append(part);
            sb.append(System.lineSeparator());
        }
        sb.append("-----END PUBLIC KEY-----");
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public static String toHexString(PublicKey publicKey, boolean lowerCase) {
        return HexExtensions.toHexString(publicKey.getEncoded(), lowerCase);
    }

    public static void toPemFile(@NonNull PublicKey publicKey, @NonNull File file) throws IOException {
        if (publicKey == null) {
            throw new NullPointerException("publicKey is marked non-null but is null");
        }
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        PublicKeyWriter.writeInPemFormat(publicKey, file);
    }

    private PublicKeyExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

