/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.key.writer;

import de.alpharogroup.crypto.compound.CompoundAlgorithm;
import de.alpharogroup.crypto.factories.AlgorithmParameterSpecFactory;
import de.alpharogroup.crypto.factories.SecretKeyFactoryExtensions;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameters;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.EncryptedPrivateKeyInfo;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import lombok.NonNull;

public final class EncryptedPrivateKeyWriter {
    public static byte[] encryptPrivateKeyWithPassword(PrivateKey privateKey, String password) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException, IOException {
        byte[] privateKeyEncoded = privateKey.getEncoded();
        SecureRandom random = new SecureRandom();
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        AlgorithmParameterSpec algorithmParameterSpec = AlgorithmParameterSpecFactory.newPBEParameterSpec(salt, 20);
        SecretKey secretKey = SecretKeyFactoryExtensions.newSecretKey(password.toCharArray(), CompoundAlgorithm.PBE_WITH_SHA1_AND_DES_EDE.getAlgorithm());
        Cipher pbeCipher = Cipher.getInstance(CompoundAlgorithm.PBE_WITH_SHA1_AND_DES_EDE.getAlgorithm());
        pbeCipher.init(1, (Key)secretKey, algorithmParameterSpec);
        byte[] ciphertext = pbeCipher.doFinal(privateKeyEncoded);
        AlgorithmParameters algparms = AlgorithmParameters.getInstance(CompoundAlgorithm.PBE_WITH_SHA1_AND_DES_EDE.getAlgorithm());
        algparms.init(algorithmParameterSpec);
        EncryptedPrivateKeyInfo encinfo = new EncryptedPrivateKeyInfo(algparms, ciphertext);
        return encinfo.getEncoded();
    }

    public static void encryptPrivateKeyWithPassword(PrivateKey privateKey, @NonNull OutputStream outputStream, String password) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException, IOException {
        if (outputStream == null) {
            throw new NullPointerException("outputStream is marked non-null but is null");
        }
        byte[] encryptedPrivateKeyWithPasswordBytes = EncryptedPrivateKeyWriter.encryptPrivateKeyWithPassword(privateKey, password);
        outputStream.write(encryptedPrivateKeyWithPasswordBytes);
        outputStream.close();
    }

    public static void encryptPrivateKeyWithPassword(PrivateKey privateKey, File file, String password) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException, IllegalBlockSizeException, BadPaddingException, InvalidParameterSpecException, IOException {
        EncryptedPrivateKeyWriter.encryptPrivateKeyWithPassword(privateKey, new FileOutputStream(file), password);
    }

    private EncryptedPrivateKeyWriter() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

