/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.crypto.obfuscation.rule;

import de.alpharogroup.collections.set.SetFactory;
import de.alpharogroup.crypto.obfuscation.rule.Operation;
import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import lombok.NonNull;

public class ObfuscationOperationRule<C, RW>
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private C character;
    private Set<Integer> indexes;
    private boolean inverted;
    private Optional<C> operatedCharacter;
    private Operation operation;
    @NonNull
    private RW replaceWith;

    private static <C, RW> Set<Integer> $default$indexes() {
        return SetFactory.newHashSet((Object[])new Integer[0]);
    }

    private static <C, RW> Optional<C> $default$operatedCharacter() {
        return Optional.empty();
    }

    private static <C, RW> Operation $default$operation() {
        return Operation.NONE;
    }

    public static <C, RW> ObfuscationOperationRuleBuilder<C, RW> builder() {
        return new ObfuscationOperationRuleBuilder();
    }

    public ObfuscationOperationRuleBuilder<C, RW> toBuilder() {
        return new ObfuscationOperationRuleBuilder().character(this.character).indexes(this.indexes).inverted(this.inverted).operatedCharacter(this.operatedCharacter).operation(this.operation).replaceWith(this.replaceWith);
    }

    @NonNull
    public C getCharacter() {
        return this.character;
    }

    public Set<Integer> getIndexes() {
        return this.indexes;
    }

    public boolean isInverted() {
        return this.inverted;
    }

    public Optional<C> getOperatedCharacter() {
        return this.operatedCharacter;
    }

    public Operation getOperation() {
        return this.operation;
    }

    @NonNull
    public RW getReplaceWith() {
        return this.replaceWith;
    }

    public void setCharacter(@NonNull C character) {
        if (character == null) {
            throw new NullPointerException("character is marked non-null but is null");
        }
        this.character = character;
    }

    public void setIndexes(Set<Integer> indexes) {
        this.indexes = indexes;
    }

    public void setInverted(boolean inverted) {
        this.inverted = inverted;
    }

    public void setOperatedCharacter(Optional<C> operatedCharacter) {
        this.operatedCharacter = operatedCharacter;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public void setReplaceWith(@NonNull RW replaceWith) {
        if (replaceWith == null) {
            throw new NullPointerException("replaceWith is marked non-null but is null");
        }
        this.replaceWith = replaceWith;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ObfuscationOperationRule)) {
            return false;
        }
        ObfuscationOperationRule other = (ObfuscationOperationRule)o;
        if (!other.canEqual(this)) {
            return false;
        }
        C this$character = this.getCharacter();
        C other$character = other.getCharacter();
        if (this$character == null ? other$character != null : !this$character.equals(other$character)) {
            return false;
        }
        Set<Integer> this$indexes = this.getIndexes();
        Set<Integer> other$indexes = other.getIndexes();
        if (this$indexes == null ? other$indexes != null : !((Object)this$indexes).equals(other$indexes)) {
            return false;
        }
        if (this.isInverted() != other.isInverted()) {
            return false;
        }
        Optional<C> this$operatedCharacter = this.getOperatedCharacter();
        Optional<C> other$operatedCharacter = other.getOperatedCharacter();
        if (this$operatedCharacter == null ? other$operatedCharacter != null : !((Object)this$operatedCharacter).equals(other$operatedCharacter)) {
            return false;
        }
        Operation this$operation = this.getOperation();
        Operation other$operation = other.getOperation();
        if (this$operation == null ? other$operation != null : !this$operation.equals(other$operation)) {
            return false;
        }
        RW this$replaceWith = this.getReplaceWith();
        RW other$replaceWith = other.getReplaceWith();
        return !(this$replaceWith == null ? other$replaceWith != null : !this$replaceWith.equals(other$replaceWith));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ObfuscationOperationRule;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        C $character = this.getCharacter();
        result = result * 59 + ($character == null ? 43 : $character.hashCode());
        Set<Integer> $indexes = this.getIndexes();
        result = result * 59 + ($indexes == null ? 43 : ((Object)$indexes).hashCode());
        result = result * 59 + (this.isInverted() ? 79 : 97);
        Optional<C> $operatedCharacter = this.getOperatedCharacter();
        result = result * 59 + ($operatedCharacter == null ? 43 : ((Object)$operatedCharacter).hashCode());
        Operation $operation = this.getOperation();
        result = result * 59 + ($operation == null ? 43 : $operation.hashCode());
        RW $replaceWith = this.getReplaceWith();
        result = result * 59 + ($replaceWith == null ? 43 : $replaceWith.hashCode());
        return result;
    }

    public String toString() {
        return "ObfuscationOperationRule(character=" + this.getCharacter() + ", indexes=" + this.getIndexes() + ", inverted=" + this.isInverted() + ", operatedCharacter=" + this.getOperatedCharacter() + ", operation=" + this.getOperation() + ", replaceWith=" + this.getReplaceWith() + ")";
    }

    public ObfuscationOperationRule() {
        this.indexes = ObfuscationOperationRule.$default$indexes();
        this.operatedCharacter = ObfuscationOperationRule.$default$operatedCharacter();
        this.operation = ObfuscationOperationRule.$default$operation();
    }

    public ObfuscationOperationRule(@NonNull C character, Set<Integer> indexes, boolean inverted, Optional<C> operatedCharacter, Operation operation, @NonNull RW replaceWith) {
        if (character == null) {
            throw new NullPointerException("character is marked non-null but is null");
        }
        if (replaceWith == null) {
            throw new NullPointerException("replaceWith is marked non-null but is null");
        }
        this.character = character;
        this.indexes = indexes;
        this.inverted = inverted;
        this.operatedCharacter = operatedCharacter;
        this.operation = operation;
        this.replaceWith = replaceWith;
    }

    public static class ObfuscationOperationRuleBuilder<C, RW> {
        private C character;
        private boolean indexes$set;
        private Set<Integer> indexes;
        private boolean inverted;
        private boolean operatedCharacter$set;
        private Optional<C> operatedCharacter;
        private boolean operation$set;
        private Operation operation;
        private RW replaceWith;

        ObfuscationOperationRuleBuilder() {
        }

        public ObfuscationOperationRuleBuilder<C, RW> character(@NonNull C character) {
            if (character == null) {
                throw new NullPointerException("character is marked non-null but is null");
            }
            this.character = character;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> indexes(Set<Integer> indexes) {
            this.indexes = indexes;
            this.indexes$set = true;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> inverted(boolean inverted) {
            this.inverted = inverted;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> operatedCharacter(Optional<C> operatedCharacter) {
            this.operatedCharacter = operatedCharacter;
            this.operatedCharacter$set = true;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> operation(Operation operation) {
            this.operation = operation;
            this.operation$set = true;
            return this;
        }

        public ObfuscationOperationRuleBuilder<C, RW> replaceWith(@NonNull RW replaceWith) {
            if (replaceWith == null) {
                throw new NullPointerException("replaceWith is marked non-null but is null");
            }
            this.replaceWith = replaceWith;
            return this;
        }

        public ObfuscationOperationRule<C, RW> build() {
            Set indexes = this.indexes;
            if (!this.indexes$set) {
                indexes = ObfuscationOperationRule.$default$indexes();
            }
            Optional operatedCharacter = this.operatedCharacter;
            if (!this.operatedCharacter$set) {
                operatedCharacter = ObfuscationOperationRule.$default$operatedCharacter();
            }
            Operation operation = this.operation;
            if (!this.operation$set) {
                operation = ObfuscationOperationRule.$default$operation();
            }
            return new ObfuscationOperationRule<C, RW>(this.character, indexes, this.inverted, operatedCharacter, operation, this.replaceWith);
        }

        public String toString() {
            return "ObfuscationOperationRule.ObfuscationOperationRuleBuilder(character=" + this.character + ", indexes=" + this.indexes + ", inverted=" + this.inverted + ", operatedCharacter=" + this.operatedCharacter + ", operation=" + this.operation + ", replaceWith=" + this.replaceWith + ")";
        }
    }
}

