/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.zip;

import de.alpharogroup.file.FileConst;
import de.alpharogroup.file.exceptions.FileDoesNotExistException;
import de.alpharogroup.file.search.FileSearchExtensions;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public final class ZipExtensions {
    private static void addFile(File file, File dirToZip, ZipOutputStream zos) throws IOException {
        String absolutePath = file.getAbsolutePath();
        int index = absolutePath.indexOf(dirToZip.getName());
        String zipEntryName = absolutePath.substring(index, absolutePath.length());
        byte[] b = new byte[(int)file.length()];
        ZipEntry cpZipEntry = new ZipEntry(zipEntryName);
        zos.putNextEntry(cpZipEntry);
        zos.write(b, 0, (int)file.length());
        zos.closeEntry();
    }

    public static void extractZipEntry(ZipFile zipFile, ZipEntry target, File toDirectory) throws IOException {
        File fileToExtract = new File(toDirectory, target.getName());
        new File(fileToExtract.getParent()).mkdirs();
        try (InputStream is = zipFile.getInputStream(target);
             BufferedInputStream bis = new BufferedInputStream(is);
             FileOutputStream fos = new FileOutputStream(fileToExtract);
             BufferedOutputStream bos = new BufferedOutputStream(fos);){
            int c;
            while ((c = bis.read()) != -1) {
                bos.write((byte)c);
            }
            bos.flush();
        }
    }

    public static boolean isZip(String filename) {
        for (String element : FileConst.ZIP_EXTENSIONS) {
            if (!filename.endsWith(element)) continue;
            return true;
        }
        return false;
    }

    public static void unzip(ZipFile zipFile, File toDir) throws IOException {
        try {
            Enumeration<? extends ZipEntry> e = zipFile.entries();
            while (e.hasMoreElements()) {
                ZipEntry entry = e.nextElement();
                ZipExtensions.extractZipEntry(zipFile, entry, toDir);
            }
            zipFile.close();
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            zipFile.close();
        }
    }

    public static void zip(File fileToZip, File zipFile) throws Exception {
        ZipExtensions.zip(fileToZip, zipFile, null);
    }

    public static void zip(File dirToZip, File zipFile, FilenameFilter filter) {
        ZipExtensions.zip(dirToZip, zipFile, filter, true);
    }

    public static void zip(File dirToZip, File zipFile, FilenameFilter filter, boolean createFile) {
        try (FileOutputStream fos = new FileOutputStream(zipFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            if (!dirToZip.exists()) {
                throw new IOException("Directory with the name " + dirToZip.getName() + " does not exist.");
            }
            if (!zipFile.exists()) {
                if (createFile) {
                    zipFile.createNewFile();
                } else {
                    throw new FileDoesNotExistException("Zipfile with the name " + zipFile.getName() + " does not exist.");
                }
            }
            zos.setLevel(9);
            ZipExtensions.zipFiles(dirToZip, dirToZip, zos, filter);
            zos.flush();
            zos.finish();
            fos.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (FileDoesNotExistException e) {
            e.printStackTrace();
        }
    }

    private static void zipFiles(File file, File dirToZip, ZipOutputStream zos, FilenameFilter fileFilter) throws IOException {
        if (file.isDirectory()) {
            List<File> foundedFiles;
            if (null != fileFilter) {
                List<File> tmp;
                File[] tmpfList = file.listFiles(fileFilter);
                List<File> foundedDirs = FileSearchExtensions.listDirs(file);
                if (0 < foundedDirs.size()) {
                    tmp = Arrays.asList(tmpfList);
                    foundedDirs.addAll(tmp);
                    foundedFiles = foundedDirs;
                } else {
                    tmp = Arrays.asList(tmpfList);
                    foundedFiles = tmp;
                }
            } else {
                List<File> tmp;
                File[] fList = file.listFiles();
                foundedFiles = tmp = Arrays.asList(fList);
            }
            for (int i = 0; i < foundedFiles.size(); ++i) {
                ZipExtensions.zipFiles(foundedFiles.get(i), dirToZip, zos, fileFilter);
            }
        } else {
            ZipExtensions.addFile(file, dirToZip, zos);
        }
    }

    private ZipExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

