/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.compare;

import de.alpharogroup.checksum.FileChecksumExtensions;
import de.alpharogroup.crypto.algorithm.Algorithm;
import de.alpharogroup.file.compare.CompareFileExtensions;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;

public final class SimpleCompareFileExtensions {
    public static boolean compareFilesByAbsolutePath(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, false, true, true, true, true, true).getAbsolutePathEquality();
    }

    public static boolean compareFilesByChecksum(File sourceFile, File fileToCompare, Algorithm algorithm) throws NoSuchAlgorithmException, IOException {
        String checksumSourceFile = FileChecksumExtensions.getChecksum((File)sourceFile, (Algorithm)algorithm);
        String checksumFileToCompare = FileChecksumExtensions.getChecksum((File)fileToCompare, (Algorithm)algorithm);
        return checksumSourceFile.equals(checksumFileToCompare);
    }

    public static boolean compareFilesByChecksumAdler32(File sourceFile, File fileToCompare) throws IOException {
        long checksumFileToCompare;
        long checksumSourceFile = FileChecksumExtensions.getCheckSumAdler32((File)sourceFile);
        return checksumSourceFile == (checksumFileToCompare = FileChecksumExtensions.getCheckSumAdler32((File)fileToCompare));
    }

    public static boolean compareFilesByChecksumCRC32(File sourceFile, File fileToCompare) throws IOException {
        long checksumFileToCompare;
        long checksumSourceFile = FileChecksumExtensions.getCheckSumCRC32((File)sourceFile);
        return checksumSourceFile == (checksumFileToCompare = FileChecksumExtensions.getCheckSumCRC32((File)fileToCompare));
    }

    public static boolean compareFilesByContent(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, true, true, true, true, false).getContentEquality();
    }

    public static boolean compareFilesByExtension(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, false, true, true, true, true).getFileExtensionEquality();
    }

    public static boolean compareFilesByLastModified(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, true, true, false, true, true).getLastModifiedEquality();
    }

    public static boolean compareFilesByLength(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, true, false, true, true, true).getLengthEquality();
    }

    public static boolean compareFilesByName(File sourceFile, File fileToCompare) {
        return CompareFileExtensions.compareFiles(sourceFile, fileToCompare, true, true, true, true, false, true).getNameEquality();
    }

    private SimpleCompareFileExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

