/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.copy;

import de.alpharogroup.file.create.FileFactory;
import de.alpharogroup.file.exceptions.DirectoryAlreadyExistsException;
import de.alpharogroup.file.exceptions.FileIsADirectoryException;
import de.alpharogroup.file.exceptions.FileIsNotADirectoryException;
import de.alpharogroup.file.exceptions.FileIsSecurityRestrictedException;
import de.alpharogroup.io.StreamExtensions;
import de.alpharogroup.io.file.FileExtension;
import de.alpharogroup.throwable.ThrowableExtensions;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public final class CopyFileExtensions {
    public static boolean copyDirectory(File source, File destination) throws FileIsSecurityRestrictedException, IOException, FileIsADirectoryException, FileIsNotADirectoryException, DirectoryAlreadyExistsException {
        return CopyFileExtensions.copyDirectory(source, destination, true);
    }

    public static boolean copyDirectory(File source, File destination, boolean lastModified) throws FileIsSecurityRestrictedException, IOException, FileIsADirectoryException, FileIsNotADirectoryException, DirectoryAlreadyExistsException {
        return CopyFileExtensions.copyDirectoryWithFileFilter(source, destination, null, lastModified);
    }

    public static boolean copyDirectoryWithFileFilter(File source, File destination, FileFilter fileFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAlreadyExistsException {
        return CopyFileExtensions.copyDirectoryWithFileFilter(source, destination, fileFilter, null, lastModified);
    }

    public static boolean copyDirectoryWithFileFilter(File source, File destination, FileFilter includeFileFilter, FileFilter excludeFileFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAlreadyExistsException {
        return CopyFileExtensions.copyDirectoryWithFileFilter(source, destination, includeFileFilter, excludeFileFilter, null, lastModified);
    }

    public static boolean copyDirectoryWithFileFilter(File source, File destination, FileFilter includeFileFilter, FileFilter excludeFileFilter, Collection<File> excludeFiles, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAlreadyExistsException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        if (!destination.exists()) {
            FileFactory.newDirectory(destination);
        }
        boolean copied = false;
        File[] includeFilesArray = null != includeFileFilter ? source.listFiles(includeFileFilter) : source.listFiles();
        if (null != includeFilesArray) {
            ArrayList<File> allExcludeFilesList = null;
            if (null != excludeFileFilter) {
                File[] excludeFilesArray = source.listFiles(excludeFileFilter);
                List<File> excludeFileFilterList = Arrays.asList(excludeFilesArray);
                allExcludeFilesList = new ArrayList<File>(excludeFileFilterList);
            }
            if (excludeFiles != null && !excludeFiles.isEmpty()) {
                if (allExcludeFilesList != null) {
                    allExcludeFilesList.addAll(excludeFiles);
                } else {
                    allExcludeFilesList = new ArrayList<File>(excludeFiles);
                }
            }
            if (null != allExcludeFilesList && !allExcludeFilesList.isEmpty()) {
                for (File element : includeFilesArray) {
                    File currentFile = element;
                    if (allExcludeFilesList.contains(currentFile)) continue;
                    File copy = new File(destination, currentFile.getName());
                    copied = currentFile.isDirectory() ? CopyFileExtensions.copyDirectoryWithFileFilter(currentFile, copy, includeFileFilter, excludeFileFilter, lastModified) : CopyFileExtensions.copyFile(currentFile, copy, lastModified);
                }
            } else {
                for (File currentFile : includeFilesArray) {
                    File copy = new File(destination, currentFile.getName());
                    copied = currentFile.isDirectory() ? CopyFileExtensions.copyDirectoryWithFileFilter(currentFile, copy, includeFileFilter, excludeFileFilter, lastModified) : CopyFileExtensions.copyFile(currentFile, copy, lastModified);
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
        return copied;
    }

    public static boolean copyDirectoryWithFilenameFilter(File source, File destination, FilenameFilter filenameFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException, DirectoryAlreadyExistsException {
        return CopyFileExtensions.copyDirectoryWithFilenameFilter(source, destination, filenameFilter, null, lastModified);
    }

    public static boolean copyDirectoryWithFilenameFilter(File source, File destination, FilenameFilter includeFilenameFilter, FilenameFilter excludeFilenameFilter, boolean lastModified) throws IOException, FileIsNotADirectoryException, FileIsADirectoryException, FileIsSecurityRestrictedException {
        if (!source.isDirectory()) {
            throw new FileIsNotADirectoryException("Source file '" + source.getAbsolutePath() + "' is not a directory.");
        }
        if (!destination.exists()) {
            FileFactory.newDirectory(destination);
        }
        boolean copied = false;
        File[] includeFilesArray = null != includeFilenameFilter ? source.listFiles(includeFilenameFilter) : source.listFiles();
        if (null != includeFilesArray) {
            List<File> excludeFilesList = null;
            if (null != excludeFilenameFilter) {
                File[] excludeFilesArray = source.listFiles(excludeFilenameFilter);
                excludeFilesList = Arrays.asList(excludeFilesArray);
            }
            if (null != excludeFilesList && !excludeFilesList.isEmpty()) {
                for (File element : includeFilesArray) {
                    File currentFile = element;
                    if (excludeFilesList.contains(currentFile)) continue;
                    File copy = new File(destination, currentFile.getName());
                    copied = currentFile.isDirectory() ? CopyFileExtensions.copyDirectoryWithFilenameFilter(currentFile, copy, includeFilenameFilter, excludeFilenameFilter, lastModified) : CopyFileExtensions.copyFile(currentFile, copy, lastModified);
                }
            } else {
                for (File currentFile : includeFilesArray) {
                    File copy = new File(destination, currentFile.getName());
                    copied = currentFile.isDirectory() ? CopyFileExtensions.copyDirectoryWithFilenameFilter(currentFile, copy, includeFilenameFilter, excludeFilenameFilter, lastModified) : CopyFileExtensions.copyFile(currentFile, copy, lastModified);
                }
            }
        } else {
            throw new FileIsSecurityRestrictedException("File '" + source.getAbsolutePath() + "' is security restricted.");
        }
        return copied;
    }

    public static boolean copyFile(File source, File destination) throws IOException, FileIsADirectoryException {
        return CopyFileExtensions.copyFile(source, destination, true);
    }

    public static boolean copyFile(File source, File destination, boolean lastModified) throws IOException {
        return CopyFileExtensions.copyFile(source, destination, null, null, lastModified);
    }

    public static boolean copyFile(File source, File destination, Charset sourceEncoding, Charset destinationEncoding, boolean lastModified) throws IOException {
        boolean copied;
        if (source.isDirectory()) {
            throw new IllegalArgumentException("The source File " + destination.getName() + " should be a File but is a Directory.");
        }
        if (destination.isDirectory()) {
            throw new IllegalArgumentException("The destination File " + destination.getName() + " should be a File but is a Directory.");
        }
        try (InputStream inputStream = StreamExtensions.getInputStream((File)source);
             InputStreamReader reader = sourceEncoding != null ? new InputStreamReader(inputStream, sourceEncoding) : new InputStreamReader(inputStream);
             OutputStream outputStream = StreamExtensions.getOutputStream((File)destination, (!destination.exists() ? 1 : 0) != 0);
             BufferedOutputStream bos = new BufferedOutputStream(outputStream);
             OutputStreamWriter writer = destinationEncoding != null ? new OutputStreamWriter((OutputStream)bos, destinationEncoding) : new OutputStreamWriter(bos);){
            int tmp;
            char[] charArray = new char[8192];
            while ((tmp = reader.read(charArray)) > 0) {
                writer.write(charArray, 0, tmp);
            }
            copied = true;
        }
        if (lastModified) {
            destination.setLastModified(source.lastModified());
        }
        return copied;
    }

    public static void copyFiles(List<File> sources, File destination, Charset sourceEncoding, Charset destinationEncoding, boolean lastModified) {
        if (!destination.exists()) {
            FileFactory.newDirectory(destination);
        }
        sources.stream().forEach(ThrowableExtensions.toRuntimeExceptionIfNeeded(file -> {
            File destinationFile = new File(destination, file.getName());
            CopyFileExtensions.copyFile(file, destinationFile, sourceEncoding, destinationEncoding, lastModified);
        }));
    }

    public static boolean copyFileToDirectory(File source, File destinationDir) throws FileIsNotADirectoryException, IOException, FileIsADirectoryException {
        return CopyFileExtensions.copyFileToDirectory(source, destinationDir, true);
    }

    public static boolean copyFileToDirectory(File source, File destinationDir, boolean lastModified) throws FileIsNotADirectoryException, IOException, FileIsADirectoryException {
        if (null == destinationDir) {
            throw new IllegalArgumentException("Destination must not be null");
        }
        if (!destinationDir.isDirectory()) {
            throw new FileIsNotADirectoryException("Destination File-object '" + destinationDir.getAbsolutePath() + "' is not a directory.");
        }
        File destinationFile = new File(destinationDir, source.getName());
        return CopyFileExtensions.copyFile(source, destinationFile, lastModified);
    }

    public static File newBackupOf(File file, Charset sourceEncoding, Charset destinationEncoding) throws IOException {
        File backup = new File(file.getAbsolutePath() + FileExtension.BACKUP.getExtension());
        CopyFileExtensions.copyFile(file, backup, sourceEncoding, destinationEncoding, true);
        return backup;
    }

    private CopyFileExtensions() {
    }
}

