/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.create;

import de.alpharogroup.file.create.FileCreationState;
import de.alpharogroup.file.exceptions.DirectoryAlreadyExistsException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;

public final class FileFactory {
    public static FileCreationState newDirectories(Collection<File> directories) throws DirectoryAlreadyExistsException {
        FileCreationState created = FileCreationState.PENDING;
        for (File dir : directories) {
            created = FileFactory.newDirectory(dir);
        }
        return created;
    }

    public static boolean newDirectories(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Path directory = Files.createDirectories(dir, attrs);
        return Files.exists(directory, new LinkOption[0]);
    }

    public static FileCreationState newDirectory(File dir) {
        FileCreationState fileCreationState = FileCreationState.ALREADY_EXISTS;
        if (!dir.exists()) {
            fileCreationState = FileCreationState.FAILED;
            if (dir.mkdir()) {
                fileCreationState = FileCreationState.CREATED;
            }
        }
        return fileCreationState;
    }

    public static boolean newDirectory(Path dir, FileAttribute<?> ... attrs) throws IOException {
        Path directory = Files.createDirectory(dir, attrs);
        return Files.exists(directory, new LinkOption[0]);
    }

    public static FileCreationState newFile(File file) throws IOException {
        FileCreationState fileCreationState = FileCreationState.ALREADY_EXISTS;
        if (!file.exists()) {
            fileCreationState = FileCreationState.FAILED;
            FileFactory.newParentDirectories(file);
            if (file.createNewFile()) {
                fileCreationState = FileCreationState.CREATED;
            }
        }
        return fileCreationState;
    }

    public static FileCreationState newFiles(Collection<File> files) throws IOException {
        FileCreationState created = FileCreationState.PENDING;
        for (File file : files) {
            created = FileFactory.newFile(file);
        }
        return created;
    }

    public static void newParentDirectories(File file) {
        File parent;
        if (!file.exists() && (parent = file.getParentFile()) != null && !parent.exists()) {
            parent.mkdirs();
        }
    }

    private FileFactory() {
    }
}

