/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.file.zip;

import de.alpharogroup.file.zip.ZipExtensions;
import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class Unzipper {
    private File toDir;
    private ZipFile zipFile;

    public static UnzipperBuilder builder() {
        return new UnzipperBuilder();
    }

    public Unzipper() {
    }

    public Unzipper(File toDir, ZipFile zipFile) {
        this.toDir = toDir;
        this.zipFile = zipFile;
    }

    public Unzipper(ZipFile zipFile, File toDir) {
        this.zipFile = zipFile;
        this.toDir = toDir;
    }

    public void extractZipEntry(ZipFile zipFile, ZipEntry target, File toDirectory) throws IOException {
        ZipExtensions.extractZipEntry(zipFile, target, toDirectory);
    }

    public File getToDir() {
        return this.toDir;
    }

    public ZipFile getZipFile() {
        return this.zipFile;
    }

    public void setToDir(File toDir) {
        this.toDir = toDir;
    }

    public void setZipFile(ZipFile zipFile) {
        this.zipFile = zipFile;
    }

    public UnzipperBuilder toBuilder() {
        return new UnzipperBuilder().toDir(this.toDir).zipFile(this.zipFile);
    }

    public String toString() {
        return "Unzipper(toDir=" + this.getToDir() + ", zipFile=" + this.getZipFile() + ")";
    }

    public void unzip() throws IOException {
        this.unzip(this.zipFile, this.toDir);
    }

    public void unzip(ZipFile zipFile, File toDir) throws IOException {
        ZipExtensions.unzip(zipFile, toDir);
    }

    public static class UnzipperBuilder {
        private File toDir;
        private ZipFile zipFile;

        UnzipperBuilder() {
        }

        public Unzipper build() {
            return new Unzipper(this.toDir, this.zipFile);
        }

        public UnzipperBuilder toDir(File toDir) {
            this.toDir = toDir;
            return this;
        }

        public String toString() {
            return "Unzipper.UnzipperBuilder(toDir=" + this.toDir + ", zipFile=" + this.zipFile + ")";
        }

        public UnzipperBuilder zipFile(ZipFile zipFile) {
            this.zipFile = zipFile;
            return this;
        }
    }
}

