/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.enums;

import de.alpharogroup.check.Check;

public final class CustomizableEnum<E extends Enum<E>, T> {
    private final E enumtype;
    private final T value;

    public CustomizableEnum(E enumtype, T value) {
        if (enumtype == null) {
            Check.get().notNull(value, "value");
        }
        this.enumtype = enumtype;
        this.value = value;
    }

    public String name() {
        if (this.enumtype != null) {
            return ((Enum)this.enumtype).name();
        }
        return this.value.toString();
    }

    public static <E extends Enum<E>, T> CustomizableEnumBuilder<E, T> builder() {
        return new CustomizableEnumBuilder();
    }

    public E getEnumtype() {
        return this.enumtype;
    }

    public T getValue() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CustomizableEnum)) {
            return false;
        }
        CustomizableEnum other = (CustomizableEnum)o;
        E this$enumtype = this.getEnumtype();
        E other$enumtype = other.getEnumtype();
        if (this$enumtype == null ? other$enumtype != null : !this$enumtype.equals(other$enumtype)) {
            return false;
        }
        T this$value = this.getValue();
        T other$value = other.getValue();
        return !(this$value == null ? other$value != null : !this$value.equals(other$value));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        E $enumtype = this.getEnumtype();
        result = result * 59 + ($enumtype == null ? 43 : $enumtype.hashCode());
        T $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        return result;
    }

    public String toString() {
        return "CustomizableEnum(enumtype=" + this.getEnumtype() + ", value=" + this.getValue() + ")";
    }

    public static class CustomizableEnumBuilder<E extends Enum<E>, T> {
        private E enumtype;
        private T value;

        CustomizableEnumBuilder() {
        }

        public CustomizableEnumBuilder<E, T> enumtype(E enumtype) {
            this.enumtype = enumtype;
            return this;
        }

        public CustomizableEnumBuilder<E, T> value(T value) {
            this.value = value;
            return this;
        }

        public CustomizableEnum<E, T> build() {
            return new CustomizableEnum<E, T>(this.enumtype, this.value);
        }

        public String toString() {
            return "CustomizableEnum.CustomizableEnumBuilder(enumtype=" + this.enumtype + ", value=" + this.value + ")";
        }
    }
}

