/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.io;

import de.alpharogroup.io.StreamExtensions;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.logging.Logger;

public final class SerializedObjectExtensions {
    protected static final Logger LOGGER = Logger.getLogger(SerializedObjectExtensions.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object readSerializedObjectFromFile(File file) throws IOException, ClassNotFoundException {
        Object object = null;
        FileInputStream fis = null;
        ObjectInputStream in = null;
        try {
            fis = new FileInputStream(file);
            in = new ObjectInputStream(fis);
            object = in.readObject();
            in.close();
        }
        catch (Throwable throwable) {
            StreamExtensions.closeInputStream(in);
            StreamExtensions.closeInputStream(fis);
            throw throwable;
        }
        StreamExtensions.closeInputStream(in);
        StreamExtensions.closeInputStream(fis);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> byte[] toByteArray(T object) throws IOException {
        byte[] byArray;
        ByteArrayOutputStream byteArrayOutputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            byteArrayOutputStream = new ByteArrayOutputStream(1024);
            byteArrayOutputStream.reset();
            objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (Throwable throwable) {
            StreamExtensions.closeOutputStream(byteArrayOutputStream);
            StreamExtensions.closeOutputStream(objectOutputStream);
            throw throwable;
        }
        StreamExtensions.closeOutputStream(byteArrayOutputStream);
        StreamExtensions.closeOutputStream(objectOutputStream);
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object toObject(byte[] byteArray) throws IOException, ClassNotFoundException {
        Object object = null;
        ByteArrayInputStream byteArrayInputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            byteArrayInputStream = new ByteArrayInputStream(byteArray);
            objectInputStream = new ObjectInputStream(byteArrayInputStream);
            object = objectInputStream.readObject();
            objectInputStream.close();
        }
        catch (Throwable throwable) {
            StreamExtensions.closeInputStream(byteArrayInputStream);
            StreamExtensions.closeInputStream(objectInputStream);
            throw throwable;
        }
        StreamExtensions.closeInputStream(byteArrayInputStream);
        StreamExtensions.closeInputStream(objectInputStream);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean writeSerializedObjectToFile(Object obj, File file) throws IOException {
        boolean written = true;
        FileOutputStream fos = null;
        ObjectOutputStream oos = null;
        try {
            fos = new FileOutputStream(file);
            oos = new ObjectOutputStream(fos);
            oos.writeObject(obj);
            oos.flush();
            oos.close();
        }
        catch (Throwable throwable) {
            StreamExtensions.closeOutputStream(oos);
            StreamExtensions.closeOutputStream(fos);
            throw throwable;
        }
        StreamExtensions.closeOutputStream(oos);
        StreamExtensions.closeOutputStream(fos);
        return true;
    }

    private SerializedObjectExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

