/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.io;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;

public final class StreamExtensions
implements Serializable {
    private static final long serialVersionUID = 5042445056004440533L;

    public static void close(InputStream in) throws IOException {
        try {
            if (in != null) {
                in.close();
                in = null;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static void close(OutputStream out) throws IOException {
        try {
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (out != null) {
                out.flush();
                out.close();
            }
        }
    }

    public static void close(Reader reader) throws IOException {
        try {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void close(Writer writer) throws IOException {
        try {
            if (writer != null) {
                writer.flush();
                writer.close();
                writer = null;
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (writer != null) {
                writer.flush();
                writer.close();
            }
        }
    }

    public static boolean closeInputStream(InputStream in) {
        boolean closed = true;
        try {
            if (in != null) {
                in.close();
                in = null;
            }
        }
        catch (IOException e) {
            closed = false;
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (IOException e) {
                closed = false;
            }
        }
        return closed;
    }

    public static boolean closeOutputStream(OutputStream out) {
        boolean closed = true;
        try {
            if (out != null) {
                out.flush();
                out.close();
                out = null;
            }
        }
        catch (IOException e) {
            closed = false;
        }
        finally {
            try {
                if (out != null) {
                    out.flush();
                    out.close();
                }
            }
            catch (IOException e) {
                closed = false;
            }
        }
        return closed;
    }

    public static boolean closeReader(Reader reader) {
        boolean closed = true;
        try {
            if (reader != null) {
                reader.close();
                reader = null;
            }
        }
        catch (IOException e) {
            closed = false;
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (IOException e) {
                closed = false;
            }
        }
        return closed;
    }

    public static boolean closeWriter(Writer writer) {
        boolean closed = true;
        try {
            if (writer != null) {
                writer.flush();
                writer.close();
                writer = null;
            }
        }
        catch (IOException e) {
            closed = false;
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException e) {
                closed = false;
            }
        }
        return closed;
    }

    public static byte[] getByteArray(InputStream in) throws IOException {
        return StreamExtensions.getByteArray(in, new ByteArrayOutputStream(in.available()));
    }

    public static byte[] getByteArray(InputStream in, ByteArrayOutputStream os) throws IOException {
        byte[] bytes = null;
        try {
            int byt;
            while ((byt = in.read()) != -1) {
                os.write(byt);
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            bytes = os.toByteArray();
        }
        return bytes;
    }

    public static InputStream getInputStream(File file) throws IOException {
        return StreamExtensions.getInputStream(file, false);
    }

    public static InputStream getInputStream(File file, boolean createFile) throws IOException {
        InputStream is = null;
        if (file.exists()) {
            is = file.toURI().toURL().openStream();
        } else if (createFile) {
            file.createNewFile();
            is = file.toURI().toURL().openStream();
        } else {
            throw new FileNotFoundException("File " + file.getName() + " does not exist.");
        }
        return is;
    }

    public static OutputStream getOutputStream(File file) throws IOException {
        return StreamExtensions.getOutputStream(file, false);
    }

    public static OutputStream getOutputStream(File file, boolean createFile) throws IOException {
        FileOutputStream os = null;
        BufferedOutputStream bos = null;
        if (file.exists()) {
            os = new FileOutputStream(file);
        } else if (createFile) {
            file.createNewFile();
            os = new FileOutputStream(file);
        } else {
            throw new FileNotFoundException("File " + file.getName() + " does not exist.");
        }
        bos = new BufferedOutputStream(os);
        return bos;
    }

    public static Reader getReader(File inputFile) throws IOException {
        return StreamExtensions.getReader(inputFile, null, false);
    }

    public static Reader getReader(File inputFile, String encoding, boolean createFile) throws IOException {
        FileInputStream fis = null;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        if (inputFile.exists()) {
            fis = new FileInputStream(inputFile);
        } else if (createFile) {
            inputFile.createNewFile();
            fis = new FileInputStream(inputFile);
        } else {
            throw new FileNotFoundException("File " + inputFile.getName() + " does not exist.");
        }
        isr = null == encoding ? new InputStreamReader(fis) : new InputStreamReader((InputStream)fis, encoding);
        reader = new BufferedReader(isr);
        return reader;
    }

    public static long getSerialVersionUID(Class<? extends Serializable> clazz) {
        return ObjectStreamClass.lookup(clazz).getSerialVersionUID();
    }

    public static Writer getWriter(File file) throws IOException {
        return StreamExtensions.getWriter(file, null, false);
    }

    public static Writer getWriter(File file, String encoding, boolean createFile) throws IOException {
        PrintWriter printWriter = null;
        BufferedOutputStream bos = null;
        FileOutputStream fos = null;
        OutputStreamWriter osw = null;
        if (file.exists()) {
            fos = new FileOutputStream(file);
        } else if (createFile) {
            file.createNewFile();
            fos = new FileOutputStream(file);
        } else {
            throw new FileNotFoundException("File " + file.getName() + "does not exist.");
        }
        bos = new BufferedOutputStream(fos);
        osw = null == encoding ? new OutputStreamWriter(bos) : new OutputStreamWriter((OutputStream)bos, encoding);
        printWriter = new PrintWriter(osw);
        return printWriter;
    }

    public static void writeInputStreamToOutputStream(InputStream inputStream, OutputStream outputStream, boolean closeStream) throws IOException {
        try {
            int byt;
            while ((byt = inputStream.read()) != -1) {
                outputStream.write(byt);
            }
            if (closeStream) {
                inputStream.close();
                outputStream.close();
            }
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (closeStream) {
                StreamExtensions.closeInputStream(inputStream);
                StreamExtensions.closeOutputStream(outputStream);
            }
        }
    }

    private StreamExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

