/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.math;

public final class MathExtensions {
    public static int[] getPrimeNumbers(int quantity) {
        int[] primes = new int[quantity];
        int i = 0;
        int number = 2;
        while (i < quantity) {
            boolean isPrime = MathExtensions.isPrime(number);
            if (isPrime) {
                primes[i++] = number;
            }
            ++number;
        }
        return primes;
    }

    public static boolean isBetween(double min, double max, double index) {
        return MathExtensions.isBetween(min, max, index, false, false);
    }

    public static boolean isBetween(double min, double max, double index, boolean includeMin, boolean includeMax) {
        if (includeMin && includeMax) {
            return index >= min && index <= max;
        }
        if (includeMin && !includeMax) {
            return index >= min && index < max;
        }
        if (!includeMin && includeMax) {
            return index > min && index <= max;
        }
        return min < index && index < max;
    }

    public static boolean isBetween(float min, float max, float index) {
        return MathExtensions.isBetween(min, max, index, false, false);
    }

    public static boolean isBetween(float min, float max, float index, boolean includeMin, boolean includeMax) {
        if (includeMin && includeMax) {
            return index >= min && index <= max;
        }
        if (includeMin && !includeMax) {
            return index >= min && index < max;
        }
        if (!includeMin && includeMax) {
            return index > min && index <= max;
        }
        return min < index && index < max;
    }

    public static boolean isBetween(int min, int max, int index) {
        return MathExtensions.isBetween(min, max, index, false, false);
    }

    public static boolean isBetween(int min, int max, int index, boolean includeMin, boolean includeMax) {
        if (includeMin && includeMax) {
            return index >= min && index <= max;
        }
        if (includeMin && !includeMax) {
            return index >= min && index < max;
        }
        if (!includeMin && includeMax) {
            return index > min && index <= max;
        }
        return min < index && index < max;
    }

    public static boolean isBetween(long min, long max, long index) {
        return MathExtensions.isBetween(min, max, index, false, false);
    }

    public static boolean isBetween(long min, long max, long index, boolean includeMin, boolean includeMax) {
        if (includeMin && includeMax) {
            return index >= min && index <= max;
        }
        if (includeMin && !includeMax) {
            return index >= min && index < max;
        }
        if (!includeMin && includeMax) {
            return index > min && index <= max;
        }
        return min < index && index < max;
    }

    public static boolean isInRange(int min, int max, int number) {
        return MathExtensions.isBetween(min, max, number);
    }

    public static boolean isNegative(double number) {
        return !MathExtensions.isPositive(number);
    }

    public static boolean isNegative(float number) {
        return !MathExtensions.isPositive(number);
    }

    public static boolean isNegative(int number) {
        return !MathExtensions.isPositive(number);
    }

    public static boolean isNegative(long number) {
        return !MathExtensions.isPositive(number);
    }

    public static boolean isNext(Integer number, Integer nextNumber) {
        int next = number + 1;
        return next == nextNumber;
    }

    public static boolean isPositive(double number) {
        boolean positive = false;
        if (0.0 < number) {
            positive = true;
        }
        return positive;
    }

    public static boolean isPositive(float number) {
        boolean positive = false;
        if (0.0 < (double)number) {
            positive = true;
        }
        return positive;
    }

    public static boolean isPositive(int number) {
        boolean positive = false;
        if (0 < number) {
            positive = true;
        }
        return positive;
    }

    public static boolean isPositive(long number) {
        boolean positive = false;
        if (0L < number) {
            positive = true;
        }
        return positive;
    }

    public static boolean isPrevious(Integer number, Integer previousNumber) {
        int previous = number - 1;
        return previous == previousNumber;
    }

    public static boolean isPrime(double n) {
        double mod = 1.0;
        double end = Math.sqrt(n);
        for (double i = 2.0; i <= end && mod != 0.0; i += 1.0) {
            mod = n % i;
        }
        return mod != 0.0;
    }

    public static boolean isPrime(float n) {
        float mod = 1.0f;
        float end = (float)Math.sqrt(n);
        for (float i = 2.0f; i <= end && mod != 0.0f; i += 1.0f) {
            mod = n % i;
        }
        return mod != 0.0f;
    }

    public static boolean isPrime(int n) {
        int mod = 1;
        int end = (int)Math.sqrt(n);
        for (int i = 2; i <= end && mod != 0; ++i) {
            mod = n % i;
        }
        return mod != 0;
    }

    public static boolean isPrime(long n) {
        long mod = 1L;
        long end = (long)Math.sqrt(n);
        for (long i = 2L; i <= end && mod != 0L; ++i) {
            mod = n % i;
        }
        return mod != 0L;
    }

    public static boolean isPrimeNumber(int number) {
        int a = 1;
        int telos = (int)Math.sqrt(number);
        for (int count = 2; count <= telos && a != 0; ++count) {
            a = number % count;
        }
        return a != 0;
    }

    public static int[] printAllPrimeNumbersTill(int noOfPrimes) {
        int[] primes;
        for (int prime : primes = MathExtensions.getPrimeNumbers(noOfPrimes)) {
            System.out.println(prime + " is a prime number");
        }
        return primes;
    }

    private MathExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

