/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.service.domain.AbstractDomainService;
import de.alpharogroup.user.domain.UserToken;
import de.alpharogroup.user.entities.UserTokens;
import de.alpharogroup.user.mapper.UserTokensMapper;
import de.alpharogroup.user.repositories.UserTokensDao;
import de.alpharogroup.user.service.api.UserTokenService;
import de.alpharogroup.user.service.api.UserTokensService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="userTokenDomainService")
public class UserTokenDomainService
extends AbstractDomainService<Integer, UserToken, UserTokens, UserTokensDao, UserTokensMapper>
implements UserTokenService {
    @Autowired
    private UserTokensService userTokensService;

    @Override
    public UserToken find(String username) {
        return (UserToken)((UserTokensMapper)this.getMapper()).toDomainObject((BaseEntity)this.userTokensService.find(username));
    }

    @Override
    public List<UserToken> findAll(String username) {
        return ((UserTokensMapper)this.getMapper()).toDomainObjects(this.userTokensService.findAll(username));
    }

    @Override
    public String getAutheticationToken(String username) {
        return this.userTokensService.getAutheticationToken(username);
    }

    @Override
    public boolean isValid(String token) {
        return this.userTokensService.isValid(token);
    }

    @Autowired
    public void setUserTokensDao(UserTokensDao usersDao) {
        this.setDao((EntityManagerDao)usersDao);
    }

    @Autowired
    public void setUserTokensMapper(UserTokensMapper mapper) {
        this.setMapper((EntityDOMapper)mapper);
    }

    public UserTokensService getUserTokensService() {
        return this.userTokensService;
    }

    public void setUserTokensService(UserTokensService userTokensService) {
        this.userTokensService = userTokensService;
    }
}

