/*
 * Decompiled with CFR 0.152.
 */
package excel.functions.plugins;

import excel.functions.macro.BioVoxxelMacroExtensionDescriptor;
import excel.functions.utils.ExcelUtils;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

public class AppendArrayAsExcelRow
implements BioVoxxelMacroExtensionDescriptor {
    protected static final Logger logger = Logger.getLogger(ExcelUtils.class.getName());

    protected static void appendArrayAsTableRow(String[] array, File workbookFile, String sheetNameOrIndexString, int startingColumn) {
        Workbook workbook;
        String[][] table2DArray = ExcelUtils.convertInRowArray(array);
        try {
            workbook = WorkbookFactory.create((File)workbookFile);
        }
        catch (EncryptedDocumentException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
            return;
        }
        logger.info("Workbook = " + workbook);
        Sheet sheet = ExcelUtils.getSheet(workbook, sheetNameOrIndexString);
        int rowCount = ExcelUtils.getRowCount(sheet);
        ExcelUtils.write2DArrayToSheet(sheet, rowCount, startingColumn, table2DArray);
        ExcelUtils.saveWorkbook(workbook, workbookFile);
    }

    @Override
    public String runFromMacro(Object[] parameters) {
        ExcelUtils.logMacroParameters(parameters);
        Object[] inputDataArray = (Object[])parameters[0];
        String[] inputDataArrayAsStringArray = new String[inputDataArray.length];
        for (int dataPoint = 0; dataPoint < inputDataArray.length; ++dataPoint) {
            inputDataArrayAsStringArray[dataPoint] = inputDataArray[dataPoint].toString();
        }
        File workbookFile = new File(ExcelUtils.fixFilePath(parameters[1].toString()));
        String sheetName = parameters[2].toString();
        int startingRow = Integer.parseInt(parameters[3].toString());
        AppendArrayAsExcelRow.appendArrayAsTableRow(inputDataArrayAsStringArray, workbookFile, sheetName, startingRow);
        return "";
    }

    @Override
    public int[] parameterTypes() {
        return new int[]{4, 1, 1, 1};
    }

    @Override
    public String description() {
        return "Appends data from an array as ROW after all existing rows starting at a defined COLUMN.";
    }

    @Override
    public String parameters() {
        return "array, filePathToExcelWorkbook, sheetNameOrIndex, startingColumn";
    }
}

